/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FMLMessage.EntityMessage msg) throws Exception {
        tr thread = FMLCommonHandler.instance().getWorldThread(ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (thread.aF()) {
            this.process(msg);
        } else {
            thread.a(() -> this.process(msg));
        }
    }

    private void process(FMLMessage.EntityMessage msg) {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            FMLMessage.EntitySpawnMessage spawnMsg = (FMLMessage.EntitySpawnMessage)msg;
            this.spawnEntity(spawnMsg);
            spawnMsg.dataStream.release();
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        if (er == null) {
            throw new RuntimeException("Could not spawn mod entity ModID: " + spawnMsg.modId + " EntityID: " + spawnMsg.modEntityTypeId + " at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ") Please contact mod author or server admin.");
        }
        bsb wc2 = FMLClientHandler.instance().getWorldClient();
        try {
            vg entity;
            if (er.hasCustomSpawning()) {
                entity = er.doCustomSpawning(spawnMsg);
            } else {
                vg[] parts;
                entity = er.newInstance((amu)wc2);
                int offset = spawnMsg.entityId - entity.S();
                entity.h(spawnMsg.entityId);
                entity.a(spawnMsg.entityUUID);
                entity.b(spawnMsg.rawX, spawnMsg.rawY, spawnMsg.rawZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof vq) {
                    ((vq)entity).aP = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.bb()) != null) {
                    for (int j2 = 0; j2 < parts.length; ++j2) {
                        parts[j2].h(parts[j2].S() + offset);
                    }
                }
            }
            ol.a((vg)entity, (double)spawnMsg.rawX, (double)spawnMsg.rawY, (double)spawnMsg.rawZ);
            bud clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                bud thrower = clientPlayer.S() == spawnMsg.throwerId ? clientPlayer : wc2.a(spawnMsg.throwerId);
                ((IThrowableEntity)((Object)entity)).setThrower((vg)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.V().a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.h(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)((Object)entity)).readSpawnData(spawnMsg.dataStream);
            }
            wc2.a(spawnMsg.entityId, entity);
        }
        catch (Exception e2) {
            throw new RuntimeException("A severe problem occurred during the spawning of an entity at (" + spawnMsg.rawX + ", " + spawnMsg.rawY + ", " + spawnMsg.rawZ + ")", e2);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log.error("EntitySpawnHandler exception", cause);
        super.exceptionCaught(ctx, cause);
    }
}

