/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class FMLProxyPacket
implements ht<hb> {
    final String channel;
    private Side target;
    private final gy payload;
    private hb netHandler;
    private NetworkDispatcher dispatcher;
    private static Multiset<String> badPackets = ConcurrentHashMultiset.create();
    private static int packetCountWarning = Integer.parseInt(System.getProperty("fml.badPacketCounter", "100"));
    static final int PART_SIZE = 1048496;
    public static final int MAX_LENGTH = 267366480;

    public FMLProxyPacket(iw original) {
        this(original.b(), original.a());
        this.target = Side.CLIENT;
    }

    public FMLProxyPacket(lh original) {
        this(original.b(), original.a());
        this.target = Side.SERVER;
    }

    public FMLProxyPacket(gy payload, String channel) {
        this.channel = channel;
        this.payload = payload;
    }

    @Override
    public void a(gy packetbuffer) throws IOException {
    }

    @Override
    public void b(gy packetbuffer) throws IOException {
    }

    @Override
    public void a(hb inethandler) {
        this.netHandler = inethandler;
        FMLEmbeddedChannel internalChannel = NetworkRegistry.INSTANCE.getChannel(this.channel, this.target);
        if (internalChannel != null) {
            internalChannel.attr(NetworkRegistry.NET_HANDLER).set(this.netHandler);
            try {
                if (internalChannel.writeInbound(this)) {
                    badPackets.add(this.channel);
                    if (badPackets.size() % packetCountWarning == 0) {
                        FMLLog.log.fatal("Detected ongoing potential memory leak. {} packets have leaked. Top offenders", (Object)badPackets.size());
                        int i2 = 0;
                        for (Multiset.Entry s : Multisets.copyHighestCountFirst(badPackets).entrySet()) {
                            if (i2++ > 10) break;
                            FMLLog.log.fatal("\t {} : {}", s.getElement(), (Object)s.getCount());
                        }
                    }
                }
                internalChannel.inboundMessages().clear();
            }
            catch (FMLNetworkException ne2) {
                FMLLog.log.error("There was a network exception handling a packet on channel {}", (Object)this.channel, (Object)ne2);
                this.dispatcher.rejectHandshake(ne2.getMessage());
            }
            catch (Throwable t) {
                FMLLog.log.error("There was a critical exception handling a packet on channel {}", (Object)this.channel, (Object)t);
                this.dispatcher.rejectHandshake("A fatal error has occurred, this connection is terminated");
            }
        }
    }

    public String channel() {
        return this.channel;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public hb handler() {
        return this.netHandler;
    }

    public ht<kx> toC17Packet() {
        return new lh(this.channel, this.payload);
    }

    public List<ht<hw>> toS3FPackets() throws IOException {
        ArrayList<ht<hw>> ret = Lists.newArrayList();
        byte[] data = this.payload.array();
        if (data.length < 1048496) {
            ret.add(new iw(this.channel, new gy(this.payload.duplicate())));
        } else {
            int parts = (int)Math.ceil((double)data.length / 1048495.0);
            if (parts > 255) {
                throw new IllegalArgumentException("Payload may not be larger than 267366480 bytes");
            }
            gy preamble = new gy(Unpooled.buffer());
            preamble.a(this.channel);
            preamble.writeByte(parts);
            preamble.writeInt(data.length);
            ret.add(new iw("FML|MP", preamble));
            int offset = 0;
            for (int x = 0; x < parts; ++x) {
                int length = Math.min(1048496, data.length - offset + 1);
                byte[] tmp = new byte[length];
                tmp[0] = (byte)(x & 0xFF);
                System.arraycopy(data, offset, tmp, 1, tmp.length - 1);
                offset += tmp.length - 1;
                ret.add(new iw("FML|MP", new gy(Unpooled.wrappedBuffer(tmp))));
            }
        }
        return ret;
    }

    public void setTarget(Side target) {
        this.target = target;
    }

    public void setDispatcher(NetworkDispatcher networkDispatcher) {
        this.dispatcher = networkDispatcher;
    }

    @Nullable
    public gw getOrigin() {
        return this.dispatcher != null ? this.dispatcher.manager : null;
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Side getTarget() {
        return this.target;
    }

    public FMLProxyPacket copy() {
        FMLProxyPacket pkt = new FMLProxyPacket(new gy(this.payload.duplicate()), this.channel);
        pkt.dispatcher = this.dispatcher;
        pkt.netHandler = this.netHandler;
        pkt.target = this.target;
        return pkt;
    }
}

