/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.magmafoundation.magma.configuration.MagmaConfig;
import org.magmafoundation.magma.downloads.DownloadServerFiles;
import org.magmafoundation.magma.downloads.LibraryDownloader;
import org.magmafoundation.magma.downloads.MagmaUpdater;

public class ServerLaunchWrapper {
    public static long beginTime;
    public static List<String> LAUNCH_ARGS;

    public static void main(String[] args) {
        System.out.println("Starting Magma");
        LAUNCH_ARGS = Arrays.asList(args);
        if (ServerLaunchWrapper.getJavaVersion() > 8) {
            try {
                throw new JavaToNewException();
            }
            catch (JavaToNewException e2) {
                e2.printStackTrace();
                System.out.println("Magma Only Support's Java 8");
                return;
            }
        }
        DownloadServerFiles.downloadMinecraftServer();
        LibraryDownloader libraryDownloader = new LibraryDownloader();
        libraryDownloader.run();
        if (!LAUNCH_ARGS.contains("-dau")) {
            System.out.println("Checking for new version...");
            MagmaUpdater magmaUpdater = new MagmaUpdater();
            if (magmaUpdater.versionChecker() && MagmaConfig.instance.magmaAutoUpdater.getValues().booleanValue()) {
                magmaUpdater.downloadJar();
            }
        }
        new ServerLaunchWrapper().run(args);
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
    }

    private ServerLaunchWrapper() {
    }

    private void run(String[] args) {
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2_server.xml");
        }
        Class<?> launchwrapper = null;
        try {
            launchwrapper = Class.forName("net.minecraft.launchwrapper.Launch", true, this.getClass().getClassLoader());
            Class.forName("org.objectweb.asm.Type", true, this.getClass().getClassLoader());
        }
        catch (Exception e2) {
            System.err.printf("We appear to be missing one or more essential library files.\nYou will need to add them to your server before FML and Forge will run successfully.", new Object[0]);
        }
        beginTime = System.nanoTime();
        try {
            Method main = launchwrapper.getMethod("main", String[].class);
            String[] allArgs = new String[args.length + 2];
            allArgs[0] = "--tweakClass";
            allArgs[1] = "net.minecraftforge.fml.common.launcher.FMLServerTweaker";
            System.arraycopy(args, 0, allArgs, 2, args.length);
            main.invoke(null, new Object[]{allArgs});
        }
        catch (Exception e3) {
            System.err.printf("A problem occurred running the Server launcher.", new Object[0]);
            e3.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static class JavaToNewException
    extends RuntimeException {
        private JavaToNewException() {
        }
    }
}

