/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final vp entity;
    protected final List<vl> slots;

    public EntityEquipmentInvWrapper(vp entity, vl.a slotType) {
        this.entity = entity;
        ArrayList<vl> slots = new ArrayList<vl>();
        for (vl slot : vl.values()) {
            if (slot.a() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    @Nonnull
    public aip getStackInSlot(int slot) {
        return this.entity.b(this.validateSlotIndex(slot));
    }

    @Override
    @Nonnull
    public aip insertItem(int slot, @Nonnull aip stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.b()) {
            return aip.a;
        }
        vl equipmentSlot = this.validateSlotIndex(slot);
        aip existing = this.entity.b(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl2 = reachedLimit = stack.E() > limit;
        if (!simulate) {
            if (existing.b()) {
                this.entity.a(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.f(reachedLimit ? limit : stack.E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.E() - limit) : aip.a;
    }

    @Override
    @Nonnull
    public aip extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return aip.a;
        }
        vl equipmentSlot = this.validateSlotIndex(slot);
        aip existing = this.entity.b(equipmentSlot);
        if (existing.b()) {
            return aip.a;
        }
        int toExtract = Math.min(amount, existing.d());
        if (existing.E() <= toExtract) {
            if (!simulate) {
                this.entity.a(equipmentSlot, aip.a);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.a(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.E() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        vl equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.a() == vl.a.b ? 1 : 64;
    }

    protected int getStackLimit(int slot, @Nonnull aip stack) {
        return Math.min(this.getSlotLimit(slot), stack.d());
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull aip stack) {
        vl equipmentSlot = this.validateSlotIndex(slot);
        if (aip.b(this.entity.b(equipmentSlot), stack)) {
            return;
        }
        this.entity.a(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull aip stack) {
        return IItemHandlerModifiable.super.isItemValid(slot, stack);
    }

    protected vl validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }
}

