/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.bukkit.inventory.Recipe;

public class ShapedOreRecipe
extends IForgeRegistryEntry.Impl<akt>
implements IShapedRecipe {
    @Deprecated
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    @Deprecated
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    @Nonnull
    protected aip output = aip.a;
    protected fi<akq> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;
    protected nf group;

    public ShapedOreRecipe(nf group, aow result, Object ... recipe) {
        this(group, new aip(result), recipe);
    }

    public ShapedOreRecipe(nf group, ain result, Object ... recipe) {
        this(group, new aip(result), recipe);
    }

    public ShapedOreRecipe(nf group, @Nonnull aip result, Object ... recipe) {
        this(group, result, CraftingHelper.parseShaped(recipe));
    }

    public ShapedOreRecipe(nf group, @Nonnull aip result, CraftingHelper.ShapedPrimer primer) {
        this.group = group;
        this.output = result.l();
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.mirrored = primer.mirrored;
    }

    @Override
    @Nonnull
    public aip a(@Nonnull afy var1) {
        return this.output.l();
    }

    @Override
    @Nonnull
    public aip b() {
        return this.output;
    }

    @Override
    public boolean a(@Nonnull afy inv, @Nonnull amu world) {
        for (int x = 0; x <= inv.j() - this.width; ++x) {
            for (int y = 0; y <= inv.i() - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(afy inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < inv.j(); ++x) {
            for (int y = 0; y < inv.i(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                akq target = akq.a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input.get(this.width - subX - 1 + subY * this.width) : this.input.get(subX + subY * this.width);
                }
                if (target.a(inv.c(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Override
    @Nonnull
    public fi<akq> d() {
        return this.input;
    }

    @Deprecated
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getRecipeWidth() {
        return this.getWidth();
    }

    @Deprecated
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getRecipeHeight() {
        return this.getHeight();
    }

    @Nonnull
    public String e() {
        return this.group == null ? "" : this.group.toString();
    }

    public boolean a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public static ShapedOreRecipe factory(JsonContext context, JsonObject json) {
        String group = rc.a(json, "group", "");
        HashMap<Character, akq> ingMap = Maps.newHashMap();
        for (Map.Entry<String, JsonElement> entry : rc.t(json, "key").entrySet()) {
            if (entry.getKey().length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(entry.getKey().toCharArray()[0]), CraftingHelper.getIngredient(entry.getValue(), context));
        }
        ingMap.put(Character.valueOf(' '), akq.a);
        JsonArray patternJ = rc.u(json, "pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = rc.a(patternJ.get(x), "pattern[" + x + "]");
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = rc.a(json, "mirrored", true);
        primer.input = fi.a(primer.width * primer.height, akq.a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                akq ing = (akq)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        aip result = CraftingHelper.getItemStack(rc.t(json, "result"), context);
        return new ShapedOreRecipe(group.isEmpty() ? null : new nf(group), result, primer);
    }

    public Recipe toBukkitRecipe() {
        throw new UnsupportedOperationException("Cannot get bukkit-recipe from ShapedOreRecipe!");
    }

    public void setKey(nf key) {
    }
}

