/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

class NamespacedDefaultedWrapper<V extends IForgeRegistryEntry<V>>
extends ey<nf, V>
implements ILockableRegistry {
    private boolean locked = false;
    private ForgeRegistry<V> delegate;

    private NamespacedDefaultedWrapper(ForgeRegistry<V> owner) {
        super(null);
        this.delegate = owner;
    }

    public void register(int id2, nf key, V value) {
        int realId;
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        if (value.getRegistryName() == null) {
            value.setRegistryName(key);
        }
        if ((realId = this.delegate.add(id2, value)) != id2 && id2 != -1) {
            FMLLog.log.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)key, (Object)value.getRegistryType().getName(), (Object)id2, (Object)realId);
        }
    }

    public void putObject(nf key, V value) {
        this.register(-1, key, value);
    }

    @Override
    public void a() {
        this.delegate.validateKey();
    }

    @Nullable
    public V getObject(@Nullable nf name) {
        return this.delegate.getValue(name);
    }

    @Nullable
    public nf getNameForObject(V value) {
        return this.delegate.getKey(value);
    }

    public boolean containsKey(nf key) {
        return this.delegate.containsKey(key);
    }

    public int getIDForObject(@Nullable V value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public V getObjectById(int id2) {
        return this.delegate.getValue(id2);
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Set<nf> c() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V getRandomObject(Random random) {
        Collection<V> values = this.delegate.getValuesCollection();
        return (V)((IForgeRegistryEntry)values.stream().skip(random.nextInt(values.size())).findFirst().orElse(this.delegate.getDefault()));
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    public static class Factory<V extends IForgeRegistryEntry<V>>
    implements IForgeRegistry.CreateCallback<V> {
        public static final nf ID = new nf("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            owner.setSlaveMap(ID, new NamespacedDefaultedWrapper((ForgeRegistry)owner));
        }
    }
}

