/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

class ObjectHolderRef {
    private Field field;
    private nf injectedObject;
    private boolean isValid;
    private ForgeRegistry<?> registry;

    ObjectHolderRef(Field field, nf injectedObject, boolean extractFromExistingValues) {
        this.registry = this.getRegistryForType(field);
        this.field = field;
        boolean bl2 = this.isValid = this.registry != null;
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (existing == null || existing == this.registry.getDefault()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isValid = false;
                    return;
                }
                this.injectedObject = ((IForgeRegistryEntry)existing).getRegistryName();
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that does not map to a registry. Ensure the registry was created during the RegistryEvent.NewRegistry event. (found : %s at %s.%s)", field.getType().getName(), field.getDeclaringClass().getName(), field.getName()));
        }
        try {
            FinalFieldHelper.makeWritable(field);
        }
        catch (ReflectiveOperationException e3) {
            throw new RuntimeException(e3);
        }
    }

    @Nullable
    private ForgeRegistry<?> getRegistryForType(Field field) {
        LinkedList typesToExamine = new LinkedList();
        typesToExamine.add(field.getType());
        ForgeRegistry registry = null;
        while (!typesToExamine.isEmpty() && registry == null) {
            Class type = (Class)typesToExamine.remove();
            Collections.addAll(typesToExamine, type.getInterfaces());
            if (!IForgeRegistryEntry.class.isAssignableFrom(type)) continue;
            registry = (ForgeRegistry)GameRegistry.findRegistry(type);
            Class parentType = type.getSuperclass();
            if (parentType == null) continue;
            typesToExamine.add(parentType);
        }
        return registry;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void apply() {
        Object thing = this.isValid && this.registry.containsKey(this.injectedObject) && !this.registry.isDummied(this.injectedObject) ? this.registry.getValue(this.injectedObject) : null;
        if (thing == null) {
            FMLLog.log.debug("Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        try {
            FinalFieldHelper.setField(this.field, null, thing);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e2) {
            FMLLog.log.warn("Unable to set {} with value {} ({})", (Object)this.field, (Object)thing, (Object)this.injectedObject, (Object)e2);
        }
    }

    private static class FinalFieldHelper {
        private static Field modifiersField;
        private static Object reflectionFactory;
        private static Method newFieldAccessor;
        private static Method fieldAccessorSet;

        private FinalFieldHelper() {
        }

        static Field makeWritable(Field f2) throws ReflectiveOperationException {
            f2.setAccessible(true);
            if (modifiersField == null) {
                Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f2, f2.getModifiers() & 0xFFFFFFEF);
            return f2;
        }

        static void setField(Field field, @Nullable Object instance, Object thing) throws ReflectiveOperationException {
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
            fieldAccessorSet.invoke(fieldAccessor, instance, thing);
        }
    }
}

