/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class RegistryBuilder<T extends IForgeRegistryEntry<T>> {
    private nf registryName;
    private Class<T> registryType;
    private nf optionalDefaultKey;
    private int minId = 0;
    private int maxId = 0x7FFFFFFE;
    private List<IForgeRegistry.AddCallback<T>> addCallback = Lists.newArrayList();
    private List<IForgeRegistry.ClearCallback<T>> clearCallback = Lists.newArrayList();
    private List<IForgeRegistry.CreateCallback<T>> createCallback = Lists.newArrayList();
    private List<IForgeRegistry.ValidateCallback<T>> validateCallback = Lists.newArrayList();
    private boolean saveToDisc = true;
    private boolean allowOverrides = true;
    private boolean allowModifications = false;
    private IForgeRegistry.DummyFactory<T> dummyFactory;
    private IForgeRegistry.MissingFactory<T> missingFactory;

    public RegistryBuilder<T> setName(nf name) {
        this.registryName = name;
        return this;
    }

    public RegistryBuilder<T> setType(Class<T> type) {
        this.registryType = type;
        return this;
    }

    public RegistryBuilder<T> setIDRange(int min, int max) {
        this.minId = min;
        this.maxId = max;
        return this;
    }

    public RegistryBuilder<T> setMaxID(int max) {
        return this.setIDRange(0, max);
    }

    public RegistryBuilder<T> setDefaultKey(nf key) {
        this.optionalDefaultKey = key;
        return this;
    }

    public RegistryBuilder<T> addCallback(Object inst) {
        if (inst instanceof IForgeRegistry.AddCallback) {
            this.add((IForgeRegistry.AddCallback)inst);
        }
        if (inst instanceof IForgeRegistry.ClearCallback) {
            this.add((IForgeRegistry.ClearCallback)inst);
        }
        if (inst instanceof IForgeRegistry.CreateCallback) {
            this.add((IForgeRegistry.CreateCallback)inst);
        }
        if (inst instanceof IForgeRegistry.ValidateCallback) {
            this.add((IForgeRegistry.ValidateCallback)inst);
        }
        if (inst instanceof IForgeRegistry.DummyFactory) {
            this.set((IForgeRegistry.DummyFactory)inst);
        }
        if (inst instanceof IForgeRegistry.MissingFactory) {
            this.set((IForgeRegistry.MissingFactory)inst);
        }
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.AddCallback<T> add) {
        this.addCallback.add(add);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.ClearCallback<T> clear) {
        this.clearCallback.add(clear);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.CreateCallback<T> create) {
        this.createCallback.add(create);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.ValidateCallback<T> validate) {
        this.validateCallback.add(validate);
        return this;
    }

    public RegistryBuilder<T> set(IForgeRegistry.DummyFactory<T> factory) {
        this.dummyFactory = factory;
        return this;
    }

    public RegistryBuilder<T> set(IForgeRegistry.MissingFactory<T> missing) {
        this.missingFactory = missing;
        return this;
    }

    public RegistryBuilder<T> disableSaving() {
        this.saveToDisc = false;
        return this;
    }

    public RegistryBuilder<T> disableOverrides() {
        this.allowOverrides = false;
        return this;
    }

    public RegistryBuilder<T> allowModification() {
        this.allowModifications = true;
        return this;
    }

    public IForgeRegistry<T> create() {
        return RegistryManager.ACTIVE.createRegistry(this.registryName, this.registryType, this.optionalDefaultKey, this.minId, this.maxId, this.getAdd(), this.getClear(), this.getCreate(), this.getValidate(), this.saveToDisc, this.allowOverrides, this.allowModifications, this.dummyFactory, this.missingFactory);
    }

    @Nullable
    private IForgeRegistry.AddCallback<T> getAdd() {
        if (this.addCallback.isEmpty()) {
            return null;
        }
        if (this.addCallback.size() == 1) {
            return this.addCallback.get(0);
        }
        return (owner, stage, id2, obj, old) -> {
            for (IForgeRegistry.AddCallback<T> cb : this.addCallback) {
                cb.onAdd(owner, stage, id2, obj, old);
            }
        };
    }

    @Nullable
    private IForgeRegistry.ClearCallback<T> getClear() {
        if (this.clearCallback.isEmpty()) {
            return null;
        }
        if (this.clearCallback.size() == 1) {
            return this.clearCallback.get(0);
        }
        return (owner, stage) -> {
            for (IForgeRegistry.ClearCallback<T> cb : this.clearCallback) {
                cb.onClear(owner, stage);
            }
        };
    }

    @Nullable
    private IForgeRegistry.CreateCallback<T> getCreate() {
        if (this.createCallback.isEmpty()) {
            return null;
        }
        if (this.createCallback.size() == 1) {
            return this.createCallback.get(0);
        }
        return (owner, stage) -> {
            for (IForgeRegistry.CreateCallback<T> cb : this.createCallback) {
                cb.onCreate(owner, stage);
            }
        };
    }

    @Nullable
    private IForgeRegistry.ValidateCallback<T> getValidate() {
        if (this.validateCallback.isEmpty()) {
            return null;
        }
        if (this.validateCallback.size() == 1) {
            return this.validateCallback.get(0);
        }
        return (owner, stage, id2, key, obj) -> {
            for (IForgeRegistry.ValidateCallback<T> cb : this.validateCallback) {
                cb.onValidate(owner, stage, id2, key, obj);
            }
        };
    }
}

