/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import net.minecraftforge.server.command.TextComponentHelper;
import net.minecraftforge.server.timings.ForgeTimings;
import net.minecraftforge.server.timings.TimeTracker;

class CommandTrack
extends CommandTreeBase {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#####0.00");

    public CommandTrack() {
        this.addSubcommand(new StartTrackingCommand());
        this.addSubcommand(new ResetTrackingCommand());
        this.addSubcommand(new TrackResultsTileEntity());
        this.addSubcommand(new TrackResultsEntity());
        this.addSubcommand(new CommandTreeHelp(this));
    }

    @Override
    public String c() {
        return "track";
    }

    @Override
    public int a() {
        return 2;
    }

    @Override
    public String b(bn sender) {
        return "commands.forge.tracking.usage";
    }

    private static class TrackResultsTileEntity
    extends TrackResultsBaseCommand<avj> {
        public TrackResultsTileEntity() {
            super(TimeTracker.TILE_ENTITY_UPDATE);
        }

        @Override
        public String c() {
            return "te";
        }

        @Override
        public String b(bn sender) {
            return "commands.forge.tracking.te.usage";
        }

        @Override
        protected hh buildTrackString(bn sender, ForgeTimings<avj> data) {
            avj te = (avj)data.getObject().get();
            if (te == null) {
                return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.invalid", new Object[0]);
            }
            String name = this.getTileEntityName(te);
            et pos = te.w();
            double averageTimings = data.getAverageTimings();
            String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + this.getTimeSuffix(averageTimings);
            return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.timingEntry", name, this.getWorldName(te.D().s.getDimension()), pos.p(), pos.q(), pos.r(), tickTime);
        }

        private String getTileEntityName(avj tileEntity) {
            nf registryId = avj.a(tileEntity.getClass());
            if (registryId == null) {
                return tileEntity.getClass().getSimpleName();
            }
            return registryId.toString();
        }
    }

    private static class TrackResultsEntity
    extends TrackResultsBaseCommand<vg> {
        public TrackResultsEntity() {
            super(TimeTracker.ENTITY_UPDATE);
        }

        @Override
        public String c() {
            return "entity";
        }

        @Override
        public String b(bn sender) {
            return "commands.forge.tracking.entity.usage";
        }

        @Override
        protected hh buildTrackString(bn sender, ForgeTimings<vg> data) {
            vg entity = (vg)data.getObject().get();
            if (entity == null) {
                return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.invalid", new Object[0]);
            }
            et currentPos = entity.c();
            String world = this.getWorldName(entity.l.s.getDimension());
            double averageTimings = data.getAverageTimings();
            String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + this.getTimeSuffix(averageTimings);
            return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.timingEntry", entity.h_(), world, currentPos.p(), currentPos.q(), currentPos.r(), tickTime);
        }
    }

    private static abstract class TrackResultsBaseCommand<T>
    extends bi {
        private TimeTracker<T> tracker;

        protected TrackResultsBaseCommand(TimeTracker<T> tracker) {
            this.tracker = tracker;
        }

        protected List<ForgeTimings<T>> getSortedTimings() {
            ArrayList<ForgeTimings<T>> list = new ArrayList<ForgeTimings<T>>();
            list.addAll(this.tracker.getTimingData());
            list.sort(Comparator.comparingDouble(ForgeTimings::getAverageTimings));
            Collections.reverse(list);
            return list;
        }

        @Override
        public void a(MinecraftServer server, bn sender, String[] args) throws ei {
            List<ForgeTimings<T>> timingsList = this.getSortedTimings();
            if (timingsList.isEmpty()) {
                sender.a(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.noData", new Object[0]));
            } else {
                timingsList.stream().filter(timings -> timings.getObject().get() != null).limit(10L).forEach(timings -> sender.a(this.buildTrackString(sender, (ForgeTimings<T>)timings)));
            }
        }

        protected abstract hh buildTrackString(bn var1, ForgeTimings<T> var2);

        protected String getTimeSuffix(double time) {
            if (time < 1000.0) {
                return "\u00b5s";
            }
            return "ms";
        }

        protected String getWorldName(int dimId) {
            ayn type = DimensionManager.getProviderType(dimId);
            if (type == null) {
                return "Dim " + dimId;
            }
            return type.b();
        }
    }

    private static class ResetTrackingCommand
    extends bi {
        private ResetTrackingCommand() {
        }

        @Override
        public String c() {
            return "reset";
        }

        @Override
        public String b(bn sender) {
            return "commands.forge.tracking.reset.usage";
        }

        @Override
        public int a() {
            return 2;
        }

        @Override
        public void a(MinecraftServer server, bn sender, String[] args) throws ei {
            if (args.length != 1) {
                throw new ep(this.b(sender), new Object[0]);
            }
            String type = args[0];
            if ("te".equals(type)) {
                TimeTracker.TILE_ENTITY_UPDATE.reset();
                sender.a(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.reset", new Object[0]));
            } else if ("entity".equals(type)) {
                TimeTracker.ENTITY_UPDATE.reset();
                sender.a(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.reset", new Object[0]));
            } else {
                throw new ep(this.b(sender), new Object[0]);
            }
        }

        @Override
        public List<String> a(MinecraftServer server, bn sender, String[] args, @Nullable et targetPos) {
            return Arrays.asList("te", "entity");
        }
    }

    private static class StartTrackingCommand
    extends bi {
        private StartTrackingCommand() {
        }

        @Override
        public void a(MinecraftServer server, bn sender, String[] args) throws ei {
            if (args.length != 2) {
                throw new ep(this.b(sender), new Object[0]);
            }
            String type = args[0];
            int duration = StartTrackingCommand.a(args[1], 1, 60);
            if ("te".equals(type)) {
                TimeTracker.TILE_ENTITY_UPDATE.reset();
                TimeTracker.TILE_ENTITY_UPDATE.enable(duration);
                sender.a(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.te.enabled", duration));
            } else if ("entity".equals(type)) {
                TimeTracker.ENTITY_UPDATE.reset();
                TimeTracker.ENTITY_UPDATE.enable(duration);
                sender.a(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.entity.enabled", duration));
            } else {
                throw new ep(this.b(sender), new Object[0]);
            }
        }

        @Override
        public List<String> a(MinecraftServer server, bn sender, String[] args, @Nullable et targetPos) {
            return Arrays.asList("te", "entity");
        }

        @Override
        public String c() {
            return "start";
        }

        @Override
        public int a() {
            return 2;
        }

        @Override
        public String b(bn sender) {
            return "commands.forge.tracking.start.usage";
        }
    }
}

