/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.permission;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

public class PermissionAPI {
    private static IPermissionHandler permissionHandler = DefaultPermissionHandler.INSTANCE;

    public static void setPermissionHandler(IPermissionHandler handler) {
        Preconditions.checkNotNull(handler, "Permission handler can't be null!");
        Preconditions.checkState(Loader.instance().getLoaderState().ordinal() <= LoaderState.PREINITIALIZATION.ordinal(), "Can't register after IPermissionHandler PreInit!");
        FMLLog.log.warn("Replacing {} with {}", (Object)permissionHandler.getClass().getName(), (Object)handler.getClass().getName());
        permissionHandler = handler;
    }

    public static IPermissionHandler getPermissionHandler() {
        return permissionHandler;
    }

    public static String registerNode(String node, DefaultPermissionLevel level, String desc) {
        Preconditions.checkNotNull(node, "Permission node can't be null!");
        Preconditions.checkNotNull(level, "Permission level can't be null!");
        Preconditions.checkNotNull(desc, "Permission description can't be null!");
        Preconditions.checkArgument(!node.isEmpty(), "Permission node can't be empty!");
        Preconditions.checkState(Loader.instance().getLoaderState().ordinal() > LoaderState.PREINITIALIZATION.ordinal(), "Can't register permission nodes before Init!");
        permissionHandler.registerNode(node, level, desc);
        return node;
    }

    public static boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        Preconditions.checkNotNull(profile, "GameProfile can't be null!");
        Preconditions.checkNotNull(node, "Permission node can't be null!");
        Preconditions.checkArgument(!node.isEmpty(), "Permission node can't be empty!");
        return permissionHandler.hasPermission(profile, node, context);
    }

    public static boolean hasPermission(aed player, String node) {
        Preconditions.checkNotNull(player, "Player can't be null!");
        return PermissionAPI.hasPermission(player.da(), node, new PlayerContext(player));
    }
}

