/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.terminalconsole;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.server.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="highlightError", category="Converter")
@ConverterKeys(value={"highlightError"})
@PerformanceSensitive(value={"allocation"})
public class HighlightErrorConverter
extends LogEventPatternConverter {
    private static final String ANSI_RESET = "\u001b[39;0m";
    private static final String ANSI_ERROR = "\u001b[31;1m";
    private static final String ANSI_WARN = "\u001b[33;1m";
    private final List<PatternFormatter> formatters;

    protected HighlightErrorConverter(List<PatternFormatter> formatters) {
        super("highlightError", null);
        this.formatters = formatters;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (TerminalConsoleAppender.isAnsiSupported()) {
            Level level = event.getLevel();
            if (level.isMoreSpecificThan(Level.ERROR)) {
                this.format(ANSI_ERROR, event, toAppendTo);
                return;
            }
            if (level.isMoreSpecificThan(Level.WARN)) {
                this.format(ANSI_WARN, event, toAppendTo);
                return;
            }
        }
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
    }

    private void format(String style, LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        toAppendTo.append(style);
        int end = toAppendTo.length();
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
        if (toAppendTo.length() == end) {
            toAppendTo.setLength(start);
        } else {
            toAppendTo.append(ANSI_RESET);
        }
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static HighlightErrorConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on highlightError. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on highlightError");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new HighlightErrorConverter(formatters);
    }
}

