/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;

public class PluginsCommand
extends BukkitCommand {
    public PluginsCommand(String name) {
        super(name);
        this.description = "Gets a list of plugins running on the server";
        this.usageMessage = "/plugins [load|unload|reload] [name]";
        this.setPermission("bukkit.command.plugins");
        this.setAliases(Arrays.asList("pl"));
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("Plugins " + this.getPluginList());
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            default: 
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> tabs;
        block2: {
            String action;
            block3: {
                tabs = new ArrayList<String>();
                if (args.length <= 1) break block2;
                action = args[0].toLowerCase();
                if (!action.equals("unload")) break block3;
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    tabs.add(plugin.getName());
                }
                break block2;
            }
            if (!action.equals("reload")) break block2;
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                tabs.add(plugin.getName());
            }
        }
        return tabs;
    }

    private String getPluginList() {
        TreeMap<String, ChatColor> plugins = new TreeMap<String, ChatColor>(String.CASE_INSENSITIVE_ORDER);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            plugins.put(plugin.getDescription().getName(), plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED);
        }
        StringBuilder pluginList = new StringBuilder();
        for (Map.Entry entry : plugins.entrySet()) {
            if (pluginList.length() > 0) {
                pluginList.append((Object)ChatColor.WHITE);
                pluginList.append(", ");
            }
            pluginList.append(entry.getValue());
            pluginList.append((String)entry.getKey());
        }
        return "(" + plugins.size() + "): " + pluginList.toString();
    }
}

