/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.attribute;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_12_R1.attribute.CraftAttributeInstance;

public class CraftAttributeMap
implements Attributable {
    private final wg handle;

    public CraftAttributeMap(wg handle) {
        this.handle = handle;
    }

    @Override
    public AttributeInstance getAttribute(Attribute attribute) {
        Preconditions.checkArgument(attribute != null, "attribute");
        wd nms = this.handle.a(CraftAttributeMap.toMinecraft(attribute.name()));
        return nms == null ? null : new CraftAttributeInstance(nms, attribute);
    }

    static String toMinecraft(String bukkit) {
        int first = bukkit.indexOf(95);
        int second = bukkit.indexOf(95, first + 1);
        StringBuilder sb = new StringBuilder(bukkit.toLowerCase(Locale.ENGLISH));
        sb.setCharAt(first, '.');
        if (second != -1) {
            sb.deleteCharAt(second);
            sb.setCharAt(second, bukkit.charAt(second + 1));
        }
        return sb.toString();
    }
}

