/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_12_R1.scoreboard.CraftTeam;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements Scoreboard {
    final bhk board;

    CraftScoreboard(bhk board) {
        this.board = board;
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        Validate.notNull(name, "Objective name cannot be null", new Object[0]);
        Validate.notNull(criteria, "Criteria cannot be null", new Object[0]);
        Validate.isTrue(name.length() <= 16, "The name '" + name + "' is longer than the limit of 16 characters", new Object[0]);
        Validate.isTrue(this.board.b(name) == null, "An objective of name '" + name + "' already exists", new Object[0]);
        CraftCriteria craftCriteria = CraftCriteria.getFromBukkit(criteria);
        bhg objective = this.board.a(name, craftCriteria.criteria);
        return new CraftObjective(this, objective);
    }

    @Override
    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull(name, "Name cannot be null", new Object[0]);
        bhg nms = this.board.b(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull(criteria, "Criteria cannot be null", new Object[0]);
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (bhg netObjective : this.board.c()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add(objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf(Iterables.transform(this.board.c(), new Function<bhg, Objective>(){

            @Override
            public Objective apply(bhg input) {
                return new CraftObjective(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull(slot, "Display slot cannot be null", new Object[0]);
        bhg objective = this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null", new Object[0]);
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null", new Object[0]);
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (bhg objective : this.board.c()) {
            scores.add(new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    @Override
    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null", new Object[0]);
        this.resetScores(player.getName());
    }

    @Override
    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null", new Object[0]);
        for (bhg objective : this.board.c()) {
            this.board.d(entry, objective);
        }
    }

    @Override
    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull(player, "OfflinePlayer cannot be null", new Object[0]);
        bhh team = this.board.g(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull(entry, "Entry cannot be null", new Object[0]);
        bhh team = this.board.g(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull(teamName, "Team name cannot be null", new Object[0]);
        bhh team = this.board.d(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf(Iterables.transform(this.board.g(), new Function<bhh, Team>(){

            @Override
            public Team apply(bhh input) {
                return new CraftTeam(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull(name, "Team name cannot be null", new Object[0]);
        Validate.isTrue(name.length() <= 16, "Team name '" + name + "' is longer than the limit of 16 characters", new Object[0]);
        Validate.isTrue(this.board.d(name) == null, "Team name '" + name + "' is already in use", new Object[0]);
        return new CraftTeam(this, this.board.e(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.board.d()) {
            players.add(Bukkit.getOfflinePlayer(playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String entry : this.board.d()) {
            entries.add(entry.toString());
        }
        return entries.build();
    }

    @Override
    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull(slot, "Slot cannot be null", new Object[0]);
        this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public bhk getHandle() {
        return this.board;
    }
}

