/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import org.apache.commons.lang3.Validate;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;

public class EntityBreedEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final LivingEntity mother;
    private final LivingEntity father;
    private final LivingEntity breeder;
    private final ItemStack bredWith;
    private int experience;
    private boolean cancel;

    public EntityBreedEvent(LivingEntity child, LivingEntity mother, LivingEntity father, LivingEntity breeder, ItemStack bredWith, int experience) {
        super(child);
        Validate.notNull(child, "Cannot have null child", new Object[0]);
        Validate.notNull(mother, "Cannot have null mother", new Object[0]);
        Validate.notNull(father, "Cannot have null father", new Object[0]);
        this.mother = mother;
        this.father = father;
        this.breeder = breeder;
        this.bredWith = bredWith;
        this.setExperience(experience);
    }

    @Override
    public LivingEntity getEntity() {
        return (LivingEntity)this.entity;
    }

    public LivingEntity getMother() {
        return this.mother;
    }

    public LivingEntity getFather() {
        return this.father;
    }

    public LivingEntity getBreeder() {
        return this.breeder;
    }

    public ItemStack getBredWith() {
        return this.bredWith;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        Validate.isTrue(experience >= 0, "Experience cannot be negative", new Object[0]);
        this.experience = experience;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

