/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.material.MaterialData;

public class ShapedRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private final ItemStack output;
    private String[] rows;
    private Map<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();

    @Deprecated
    public ShapedRecipe(ItemStack result) {
        this.key = NamespacedKey.randomKey();
        this.output = new ItemStack(result);
    }

    public ShapedRecipe(NamespacedKey key, ItemStack result) {
        Preconditions.checkArgument(key != null, "key");
        this.key = key;
        this.output = new ItemStack(result);
    }

    public ShapedRecipe shape(String ... shape) {
        Validate.notNull(shape, "Must provide a shape", new Object[0]);
        Validate.isTrue(shape.length > 0 && shape.length < 4, "Crafting recipes should be 1, 2, 3 rows, not ", shape.length);
        int lastLen = -1;
        for (String row : shape) {
            Validate.notNull(row, "Shape cannot have null rows", new Object[0]);
            Validate.isTrue(row.length() > 0 && row.length() < 4, "Crafting rows should be 1, 2, or 3 characters, not ", row.length());
            Validate.isTrue(lastLen == -1 || lastLen == row.length(), "Crafting recipes must be rectangular", new Object[0]);
            lastLen = row.length();
        }
        this.rows = new String[shape.length];
        for (int i2 = 0; i2 < shape.length; ++i2) {
            this.rows[i2] = shape[i2];
        }
        HashMap<Character, ItemStack> newIngredients = new HashMap<Character, ItemStack>();
        for (String row : shape) {
            char[] cArray = row.toCharArray();
            int n2 = cArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Character c2 = Character.valueOf(cArray[i3]);
                newIngredients.put(c2, this.ingredients.get(c2));
            }
        }
        this.ingredients = newIngredients;
        return this;
    }

    public ShapedRecipe setIngredient(char key, MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    public ShapedRecipe setIngredient(char key, Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    public ShapedRecipe setIngredient(char key, Material ingredient, int raw) {
        Validate.isTrue(this.ingredients.containsKey(Character.valueOf(key)), "Symbol does not appear in the shape:", key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new ItemStack(ingredient, 1, (short)raw));
        return this;
    }

    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, ItemStack> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    public String[] getShape() {
        return (String[])this.rows.clone();
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }
}

