/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.util;

import java.util.Collection;
import org.apache.commons.lang3.Validate;

public class StringUtil {
    public static <T extends Collection<? super String>> T copyPartialMatches(String token, Iterable<String> originals, T collection) throws UnsupportedOperationException, IllegalArgumentException {
        Validate.notNull(token, "Search token cannot be null", new Object[0]);
        Validate.notNull(collection, "Collection cannot be null", new Object[0]);
        Validate.notNull(originals, "Originals cannot be null", new Object[0]);
        for (String string : originals) {
            if (!StringUtil.startsWithIgnoreCase(string, token)) continue;
            collection.add((String)string);
        }
        return collection;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) throws IllegalArgumentException, NullPointerException {
        Validate.notNull(string, "Cannot check a null string for a match", new Object[0]);
        if (string.length() < prefix.length()) {
            return false;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

