/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.commands;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.magmafoundation.magma.api.PlayerAPI;
import org.magmafoundation.magma.api.ServerAPI;

public class MagmaCommand
extends Command {
    public MagmaCommand(String name) {
        super(name);
        this.description = "Magma commands";
        this.usageMessage = "/magma [mods|playermods]";
        this.setPermission("magma.commands.magma");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length <= 1) {
            return bi.a(args, "mods", "playermods");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.hasPermission("magma.commands.magma")) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "You don't got the permission to execute this command!");
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "mods": {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + ServerAPI.getModSize() + " " + ServerAPI.getModList());
                break;
            }
            case "playermods": {
                if (args.length == 1) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                    return false;
                }
                Player player = Bukkit.getPlayer(args[1].toString());
                if (player != null) {
                    sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + PlayerAPI.getModSize(player) + " " + PlayerAPI.getModlist(player));
                    break;
                }
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The player [" + args[1] + "] is not online.");
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }
}

