/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.commands;

import java.util.Arrays;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.magmafoundation.magma.utils.TPSTracker;

public class TPSCommand
extends Command {
    public TPSCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("spigot.command.tps");
    }

    public static String format(double tps) {
        return (tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED)).toString() + (tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }

    private static final long mean(long[] array) {
        if (array == null) {
            return -1L;
        }
        long r2 = 0L;
        for (long i2 : array) {
            r2 += i2;
        }
        return r2 / (long)array.length;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        ChatColor colourTPS;
        if (!this.testPermission(sender)) {
            return true;
        }
        World currentWorld = null;
        if (sender instanceof CraftPlayer) {
            currentWorld = ((CraftPlayer)sender).getWorld();
        }
        sender.sendMessage(String.format("%s%s%s-----------%s%s%s<%s%s Worlds %s%s%s>%s%s%s-----------", new Object[]{ChatColor.GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.DARK_GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.GREEN, ChatColor.ITALIC, ChatColor.DARK_GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH}));
        MinecraftServer server = MinecraftServer.getServerInst();
        for (World world : server.server.getWorlds()) {
            if (!(world instanceof CraftWorld)) continue;
            boolean current = currentWorld != null && currentWorld == world;
            oo mcWorld = ((CraftWorld)world).getHandle();
            String bukkitName = world.getName();
            int dimensionId = mcWorld.s.getDimension();
            String name = mcWorld.s.q().b();
            String displayName = name.equals(bukkitName) ? name : String.format("%s | %s", name, bukkitName);
            double worldTickTime = (double)TPSCommand.mean((long[])server.worldTickTimes.get(dimensionId)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            colourTPS = worldTPS >= 18.0 ? ChatColor.GREEN : (worldTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
            sender.sendMessage(String.format("%s[%d] %s%s %s- %s%.2fms / %s%.2ftps", new Object[]{ChatColor.GOLD, dimensionId, current ? ChatColor.GREEN : ChatColor.YELLOW, displayName, ChatColor.RESET, ChatColor.YELLOW, worldTickTime, colourTPS, worldTPS}));
        }
        double meanTickTime = (double)TPSCommand.mean(server.h) * 1.0E-6;
        double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
        colourTPS = meanTPS >= 18.0 ? ChatColor.GREEN : (meanTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
        sender.sendMessage(String.format("%s%sOverall: %s%s%.2fms / %s%.2ftps", new Object[]{ChatColor.WHITE, ChatColor.BOLD, ChatColor.RESET, ChatColor.YELLOW, meanTickTime, colourTPS, meanTPS}));
        double[] tps = Bukkit.getTPS();
        String[] tpsAvg = (String[])Arrays.stream(tps).mapToObj(TPSCommand::format).toArray(String[]::new);
        sender.sendMessage(String.format("%s%s%s-----------%s%s%s<%s%s TPS Graph (48 Seconds) %s%s%s>%s%s%s-----------", new Object[]{ChatColor.GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.DARK_GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.GREEN, ChatColor.ITALIC, ChatColor.DARK_GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.GRAY, ChatColor.BOLD, ChatColor.STRIKETHROUGH}));
        if (!TPSTracker.lines.isEmpty()) {
            TPSTracker.lines.forEach(sender::sendMessage);
        }
        String status = (Object)((Object)ChatColor.GRAY) + "Unknown";
        try {
            double currentTPS = 20.0;
            if (currentTPS >= 17.0) {
                status = (Object)((Object)ChatColor.GREEN) + "STABLE";
            } else if (currentTPS >= 15.0) {
                status = (Object)((Object)ChatColor.YELLOW) + "SOME STABILITY ISSUES";
            } else if (currentTPS >= 10.0) {
                status = (Object)((Object)ChatColor.RED) + "LAGGING. CHECK TIMINGS.";
            } else if (currentTPS < 10.0) {
                status = (Object)((Object)ChatColor.DARK_RED) + "UNSTABLE";
            } else if (currentTPS < 3.0) {
                status = (Object)((Object)ChatColor.RED) + "SEND HELP!!!!!";
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        sender.sendMessage(String.format("%s%sServer Status: %s", new Object[]{ChatColor.WHITE, ChatColor.BOLD, status}));
        return true;
    }
}

