/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.configuration;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.magmafoundation.magma.commands.MagmaCommand;
import org.magmafoundation.magma.commands.TPSCommand;
import org.magmafoundation.magma.commands.VersionCommand;
import org.magmafoundation.magma.configuration.ConfigBase;
import org.magmafoundation.magma.configuration.value.Value;
import org.magmafoundation.magma.configuration.value.values.BooleanValue;
import org.magmafoundation.magma.configuration.value.values.IntValue;
import org.magmafoundation.magma.configuration.value.values.StringArrayValue;
import org.magmafoundation.magma.configuration.value.values.StringValue;

public class MagmaConfig
extends ConfigBase {
    public static MagmaConfig instance = new MagmaConfig();
    public final BooleanValue debugPrintBukkitMatterials = new BooleanValue(this, "debug.debugPrintBukkitMatterials", false, "Prints the Forge Bukkit Materials");
    public final BooleanValue debugPrintBukkitBannerPatterns = new BooleanValue(this, "debug.debugPrintBukkitBannerPatterns", false, "Prints the Forge Bukkit Banner Patterns");
    public final BooleanValue debugPrintCommandNode = new BooleanValue(this, "debug.debugPrintCommandNode", false, "Prints out all Command Nodes for permissions");
    public final BooleanValue blacklistedModsEnable = new BooleanValue(this, "forge.blacklistedmods.enabled", false, "Enable blacklisting of mods");
    public final StringArrayValue blacklistedMods = new StringArrayValue(this, "forge.blacklistedmods.list", "", "A list of mods to blacklist");
    public final StringValue blacklistedModsKickMessage = new StringValue(this, "forge.blacklistedmods.kickmessage", "Please Remove Blacklisted Mods", "Mod Blacklist kick message");
    public final IntValue expMergeMaxValue = new IntValue(this, "experience-merge-max-value", -1, "Instructs the server put a maximum value on experience orbs, preventing them all from merging down into 1 single orb.");
    public List<Integer> autoUnloadDimensions = Lists.newArrayList(13371337);
    public final StringArrayValue fakePlayerPermissions = new StringArrayValue(this, "fakeplayer.permissions", "", "A list of permissions that fake players should have");
    public final BooleanValue forgeBukkitPermissionHandlerEnable = new BooleanValue(this, "forge.bukkitPermissionHandler.enable", true, "Let's Bukkit permission plugins handle forge/modded commands");
    public final BooleanValue magmaAutoUpdater = new BooleanValue(this, "magma.auto-update", true, "Auto updates the Magma jar");
    public final BooleanValue overrideServerBrand = new BooleanValue(this, "magma.advanced.override-brand", false, "Enables overriding the brand string");
    public final StringValue serverBrand = new StringValue(this, "magma.advanced.override-brand-name", "Spigot", "Value to use for new brand string");
    public final StringValue serverBrandType = new StringValue(this, "magma.advanced.server-type", "FML", "Set to FML to show forge icon or BUKKIT to show bukkit icon (FML is default)");
    private final String HEADER = "This is the main configuration file for Magma.\n\nSite: https://magmafoundation.org\nDiscord: https://discord.gg/6rkqngA\n";

    public MagmaConfig() {
        super("magma.yml", "magma");
        this.init();
    }

    public static String getString(String s, String key, String defaultreturn) {
        if (s.contains(key)) {
            String string = s.substring(s.indexOf(key));
            String s1 = string.substring(string.indexOf(": ") + 2);
            String[] ss = s1.split("\n");
            return ss[0].trim().replace("'", "").replace("\"", "");
        }
        return defaultreturn;
    }

    public static String getString(File f2, String key, String defaultreturn) {
        try {
            String s = FileUtils.readFileToString(f2, "UTF-8");
            if (s.contains(key)) {
                String string = s.substring(s.indexOf(key));
                String s1 = string.substring(string.indexOf(": ") + 2);
                String[] ss = s1.split("\n");
                return ss[0].trim().replace("'", "").replace("\"", "");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return defaultreturn;
    }

    public void init() {
        for (Field f2 : this.getClass().getFields()) {
            if (!Modifier.isFinal(f2.getModifiers()) || !Modifier.isPublic(f2.getModifiers()) || Modifier.isStatic(f2.getModifiers())) continue;
            try {
                Value value = (Value)f2.get(this);
                if (value == null) continue;
                this.values.put(value.path, value);
            }
            catch (ClassCastException value) {
            }
            catch (Throwable t) {
                System.out.println("[Magma] Failed to initialize a MagmaConfig values.");
                t.printStackTrace();
            }
        }
        this.load();
    }

    @Override
    protected void addCommands() {
        this.commands.put("magma", new MagmaCommand("magma"));
        this.commands.put("tps", new TPSCommand("tps"));
        this.commands.put("version", new VersionCommand("version"));
    }

    @Override
    protected void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            StringBuilder header = new StringBuilder("This is the main configuration file for Magma.\n\nSite: https://magmafoundation.org\nDiscord: https://discord.gg/6rkqngA\n\n");
            for (Value toggle : this.values.values()) {
                if (!toggle.description.equals("")) {
                    header.append("Value: ").append(toggle.path).append(" Default: ").append(toggle.key).append("   # ").append(toggle.description).append("\n");
                }
                this.config.addDefault(toggle.path, toggle.key);
                ((Value)this.values.get(toggle.path)).setValues(this.config.getString(toggle.path));
            }
            this.version = this.getInt("config-version", 2);
            this.set("config-version", 2);
            this.config.addDefault("forge.autoUnloadDimensions", new int[]{-1});
            this.autoUnloadDimensions = this.config.getIntegerList("forge.autoUnloadDimensions");
            this.config.options().header(header.toString());
            this.config.options().copyDefaults(true);
            this.save();
        }
        catch (Exception ex2) {
            MinecraftServer.getServerInstance().server.getLogger().log(Level.SEVERE, "Could not load " + this.configFile);
            ex2.printStackTrace();
        }
    }
}

