/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.downloads;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.magmafoundation.magma.Magma;

public class MagmaUpdater {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private String time;
    private String newSha;
    private String currentSha;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean versionChecker() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("https://ci.hexeption.dev/job/Magma%20Foundation/job/Magma/job/master/lastSuccessfulBuild/api/json").openStream()));){
            JsonObject changeSet;
            JsonObject root = gson.fromJson((Reader)reader, JsonObject.class);
            JsonArray changeSetsItems = root.get("changeSets").getAsJsonArray();
            try {
                changeSet = changeSetsItems.get(0).getAsJsonObject().get("items").getAsJsonArray().size() > 1 ? changeSetsItems.get(0).getAsJsonObject().get("items").getAsJsonArray().get(changeSetsItems.get(0).getAsJsonObject().get("items").getAsJsonArray().size() - 1).getAsJsonObject() : changeSetsItems.get(0).getAsJsonObject().get("items").getAsJsonArray().get(0).getAsJsonObject();
            }
            catch (IndexOutOfBoundsException e2) {
                System.out.println("Failed to retrieve latest version.");
                boolean bl2 = false;
                if (reader == null) return bl2;
                if (var2_3 == null) {
                    reader.close();
                    return bl2;
                }
                try {
                    reader.close();
                    return bl2;
                }
                catch (Throwable throwable) {
                    var2_3.addSuppressed(throwable);
                    return bl2;
                }
            }
            this.time = changeSet.get("date").toString().replace("+0100", "").replaceAll("\"", "");
            this.newSha = changeSet.get("commitId").toString().replaceAll("\"", "").substring(0, 7);
            this.currentSha = Magma.class.getPackage().getImplementationVersion();
            if (this.currentSha.equals(this.newSha)) {
                System.out.println(String.format("No update found, latest version: (%s) current version: (%s)", this.currentSha, this.newSha));
                boolean bl3 = false;
                return bl3;
            }
            System.out.println(String.format("The latest Magma version is (%s) but you have (%s). The latest version was built on %s at %s.", this.newSha, this.currentSha, this.time.substring(0, 10), this.time.substring(11, 19)));
            boolean bl4 = true;
            return bl4;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return false;
        }
    }

    public void downloadJar() {
        String url = "https://ci.hexeption.dev/job/Magma%20Foundation/job/Magma/job/master/lastSuccessfulBuild/artifact/build/distributions/Magma-" + this.newSha + "-server.jar";
        try {
            Path path = Paths.get(MagmaUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            System.out.println("Updating Magma Jar ...");
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(path.toFile());
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (IOException | URISyntaxException e2) {
            System.out.println("Failed to download update! Starting old version.");
            return;
        }
        System.out.println("Download Complete! Please restart the server.");
        System.exit(0);
    }
}

