/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.log4j;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="highlightLevel", category="Converter")
@ConverterKeys(value={"highlightLevel"})
@PerformanceSensitive(value={"allocation"})
public class HighlightLevelConverter
extends LogEventPatternConverter {
    private static final String ANSI_RESET = "\u001b[39;0m";
    private static final String ANSI_ERROR = HighlightLevelConverter.getError();
    private static final String ANSI_WARN = HighlightLevelConverter.getWarn();
    private static final String ANSI_INFO = HighlightLevelConverter.getInfo();
    private static final String ANSI_FATAL = HighlightLevelConverter.getFatal();
    private static final String ANSI_TRACE = HighlightLevelConverter.getTrace();
    private final List<PatternFormatter> formatters;

    protected HighlightLevelConverter(List<PatternFormatter> formatters) {
        super("highlightLevel", null);
        this.formatters = formatters;
    }

    @Nullable
    public static HighlightLevelConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on highlightLevel. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on highlightLevel");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new HighlightLevelConverter(formatters);
    }

    public static String getError() {
        return HighlightLevelConverter.getColor("c", "\u001b[31;1m");
    }

    public static String getWarn() {
        return HighlightLevelConverter.getColor("e", "\u001b[33;1m");
    }

    public static String getInfo() {
        return HighlightLevelConverter.getColor("2", "\u001b[32;22m");
    }

    public static String getFatal() {
        return HighlightLevelConverter.getColor("e", "\u001b[31;1m");
    }

    public static String getTrace() {
        return HighlightLevelConverter.getColor("e", "\u001b[31;1m");
    }

    private static String getColor(String text, String d2) {
        switch (text) {
            case "1": {
                text = "\u001b[34;22m";
                break;
            }
            case "2": {
                text = "\u001b[32;22m";
                break;
            }
            case "3": {
                text = "\u001b[36;22m";
                break;
            }
            case "4": {
                text = "\u001b[31;22m";
                break;
            }
            case "5": {
                text = "\u001b[35;22m";
                break;
            }
            case "6": {
                text = "\u001b[33;22m";
                break;
            }
            case "7": {
                text = "\u001b[37;22m";
                break;
            }
            case "8": {
                text = "\u001b[30;1m";
                break;
            }
            case "9": {
                text = "\u001b[34;1m";
                break;
            }
            case "a": {
                text = "\u001b[32;1m";
                break;
            }
            case "b": {
                text = "\u001b[36;1m";
                break;
            }
            case "c": {
                text = "\u001b[31;1m";
                break;
            }
            case "d": {
                text = "\u001b[35;1m";
                break;
            }
            case "e": {
                text = "\u001b[33;1m";
                break;
            }
            case "f": {
                text = "\u001b[37;1m";
                break;
            }
            case "r": {
                text = ANSI_RESET;
                break;
            }
            default: {
                text = d2;
            }
        }
        return text;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Level level = event.getLevel();
        if (level.isMoreSpecificThan(Level.ERROR)) {
            this.format(ANSI_ERROR, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            this.format(ANSI_WARN, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            this.format(ANSI_INFO, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.FATAL)) {
            this.format(ANSI_FATAL, event, toAppendTo);
            return;
        }
        if (level.isMoreSpecificThan(Level.TRACE)) {
            this.format(ANSI_TRACE, event, toAppendTo);
            return;
        }
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
    }

    private void format(String style, LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        toAppendTo.append(style);
        int end = toAppendTo.length();
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
        if (toAppendTo.length() == end) {
            toAppendTo.setLength(start);
        } else {
            toAppendTo.append(ANSI_RESET);
        }
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }
}

