/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import org.magmafoundation.magma.patcher.Patcher;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class PatcherManager {
    private List<Patcher> patcherList = new ArrayList<Patcher>();

    public void init() {
        this.initPatches();
        FMLLog.info("%s patches loaded!", this.patcherList.size());
        this.patcherList.forEach(patcher -> FMLLog.info("%s [%s] loaded", patcher.getName(), patcher.getDescription()));
    }

    private void initPatches() {
        Reflections reflections = new Reflections(Patcher.class.getPackage().getName(), new Scanner[0]);
        reflections.getTypesAnnotatedWith(Patcher.PatcherInfo.class).forEach(aClass -> {
            try {
                Patcher patcher = (Patcher)aClass.newInstance();
                this.patcherList.add(patcher);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                e2.printStackTrace();
            }
        });
    }

    public List<Patcher> getPatcherList() {
        return this.patcherList;
    }

    public <T extends Patcher> Patcher getPatchByClass(Class<T> clazz) {
        return this.patcherList.stream().filter(patcher -> patcher.getClass().equals(clazz)).findFirst().map(clazz::cast).orElse(null);
    }

    public Patcher getPatchByName(String patchName) {
        return this.patcherList.stream().filter(patcher -> patcher.getName().toLowerCase().replaceAll(" ", "").equalsIgnoreCase(patchName)).findFirst().orElse(null);
    }
}

