/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher.impl;

import org.magmafoundation.magma.patcher.Patcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Patcher.PatcherInfo(name="CoreProtect", description="Changes Material to Magma's getBlockMaterial that has modded block materials ")
public class CoreProtectPatcher
extends Patcher {
    @Override
    public byte[] transform(String className, byte[] clazz) {
        if (className.equals("net.coreprotect.CoreProtectAPI") || className.equals("net.coreprotect.Functions")) {
            return this.remapMaterial(clazz);
        }
        return clazz;
    }

    private byte[] remapMaterial(byte[] clazz) {
        ClassReader classReader = new ClassReader(clazz);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode methodNode : classNode.methods) {
            for (AbstractInsnNode nextNode : methodNode.instructions) {
                if (!(nextNode instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)nextNode;
                if (methodInsnNode.owner.equals("org/bukkit/Material") && methodInsnNode.name.equals("getMaterial") && methodInsnNode.desc.equals("(Ljava/lang/String;)Lorg/bukkit/Material;")) {
                    methodInsnNode.name = "getItemOrBlockMaterial";
                    continue;
                }
                if (!methodInsnNode.owner.equals("org/bukkit/Material") || !methodInsnNode.name.equals("getMaterial") || !methodInsnNode.desc.equals("(I)Lorg/bukkit/Material;")) continue;
                methodInsnNode.name = "getBlockMaterial";
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

