/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher.impl;

import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.patcher.Patcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Patcher.PatcherInfo(name="dynmap", description="Remaps BukkitVersionHelperCB and BukkitVersionHelperGeneric to support Magma version")
public class DynmapPatcher
extends Patcher {
    @Override
    public byte[] transform(String className, byte[] clazz) {
        if (className.equals("org.dynmap.bukkit.helper.BukkitVersionHelperCB")) {
            return this.arrayRemap(this.patchBukkitVersionHelperCB(clazz));
        }
        if (className.equals("org.dynmap.bukkit.helper.BukkitVersionHelperGeneric")) {
            return this.arrayRemap(clazz);
        }
        return clazz;
    }

    private byte[] arrayRemap(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof LdcInsnNode)) continue;
                LdcInsnNode ldcInsnNode = (LdcInsnNode)next;
                if (!(ldcInsnNode.cst instanceof String)) continue;
                String str = (String)ldcInsnNode.cst;
                if ("[Lnet.minecraft.server.Block;".equals(str)) {
                    ldcInsnNode.cst = "[Lnet.minecraft.block.Block;";
                    continue;
                }
                if (!"[Lnet.minecraft.server.BiomeBase;".equals(str)) continue;
                ldcInsnNode.cst = "[Lnet.minecraft.world.biome.Biome;";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBukkitVersionHelperCB(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getNMSPackage")) continue;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)("net.minecraft.server." + Magma.getBukkitVersion())));
            insnList.add((AbstractInsnNode)new InsnNode(176));
            method.instructions = insnList;
            method.tryCatchBlocks.clear();
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

