/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher.impl;

import com.google.common.collect.ImmutableMap;
import org.bukkit.Material;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.magmafoundation.magma.patcher.Patcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Patcher.PatcherInfo(name="Essentials", description="Fixes Commands in Essentials")
public class EssentialsPatcher
extends Patcher {
    @Override
    public byte[] transform(String className, byte[] clazz) {
        if (className.equals("com.earth2me.essentials.commands.Commandhat")) {
            return this.patchCommand(clazz);
        }
        return clazz;
    }

    private byte[] patchCommand(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("registerPermissionsIfNecessary") || !method.desc.equals("(Lorg/bukkit/plugin/PluginManager;)V")) continue;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(EssentialsPatcher.class), "registerPermissionsIfNecessary", "(Lorg/bukkit/plugin/PluginManager;)V", false));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            method.instructions = insnList;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void registerPermissionsIfNecessary(PluginManager toRegister) {
        Permission hatPerm = toRegister.getPermission("essentials.hat.prevent-type.*");
        if (hatPerm != null) {
            return;
        }
        ImmutableMap.Builder<String, Boolean> children = ImmutableMap.builder();
        for (Material mat : Material.values()) {
            String matPerm;
            if (mat.getMaterialType() != Material.MaterialType.VANILLA && mat.getMaterialType() != Material.MaterialType.MOD_ITEM || toRegister.getPermission(matPerm = "essentials.hat.prevent-type." + mat.name().toLowerCase()) != null) continue;
            children.put(matPerm, true);
            toRegister.addPermission(new Permission(matPerm, "Prevent using " + (Object)((Object)mat) + " as a type of hat.", PermissionDefault.FALSE));
        }
        toRegister.addPermission(new Permission("essentials.hat.prevent-type.*", "Prevent all types of hats", PermissionDefault.FALSE, children.build()));
    }
}

