/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.proxy;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.PluginClassLoader;
import org.magmafoundation.magma.remapper.utils.RemappingUtils;

public class DelegateURLClassLoder
extends URLClassLoader {
    public static final String desc = DelegateURLClassLoder.class.getName().replace('.', '/');
    private final PluginDescriptionFile description;
    private final Map<String, Class<?>> classeCache = new HashMap();

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        PluginDescriptionFile description = null;
        Class<?> curClass = this.getClass();
        ClassLoader classLoader = curClass.getClassLoader();
        while (classLoader != null) {
            if (classLoader instanceof PluginClassLoader) {
                description = ((PluginClassLoader)classLoader).getDescription();
                break;
            }
            classLoader = classLoader.getClass().getClassLoader();
        }
        this.description = description;
    }

    public DelegateURLClassLoder(URL[] urls) {
        super(urls);
        PluginDescriptionFile description = null;
        Class<?> curClass = this.getClass();
        ClassLoader classLoader = curClass.getClassLoader();
        while (classLoader != null) {
            if (classLoader instanceof PluginClassLoader) {
                description = ((PluginClassLoader)classLoader).getDescription();
                break;
            }
            classLoader = classLoader.getClass().getClassLoader();
        }
        this.description = description;
    }

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        PluginDescriptionFile description = null;
        Class<?> curClass = this.getClass();
        ClassLoader classLoader = curClass.getClassLoader();
        while (classLoader != null) {
            if (classLoader instanceof PluginClassLoader) {
                description = ((PluginClassLoader)classLoader).getDescription();
                break;
            }
            classLoader = classLoader.getClass().getClassLoader();
        }
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("net.minecraft.server.")) {
            String mapName = RemappingUtils.map(name.replace('.', '/')).replace('/', '.');
            return JavaPlugin.class.getClassLoader().loadClass(mapName);
        }
        Class<?> result = this.classeCache.get(name);
        if (result != null) {
            return result;
        }
        String string = name.intern();
        synchronized (string) {
            result = this.classeCache.get(name);
            if (result != null) {
                return result;
            }
            result = this.remappedFindClass(name);
            if (result == null) {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException e2) {
                    result = ((LaunchClassLoader)MinecraftServer.getServerInstance().getClass().getClassLoader()).findClass(name);
                }
            }
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
            this.cacheClass(name, result);
        }
        return result;
    }

    protected Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            JarURLConnection jarURLConnection;
            URL jarURL;
            CodeSource codeSource;
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            if (stream == null) {
                return null;
            }
            byte[] bytecode = IOUtils.toByteArray(stream);
            result = this.defineClass(name, bytecode = RemappingUtils.remapFindClass(this.description, name, bytecode), 0, bytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]));
            if (result != null) {
                this.resolveClass(result);
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to remap class " + name, t);
        }
        return result;
    }

    protected void cacheClass(String name, Class<?> clazz) {
        this.classeCache.put(name, clazz);
        if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            ConfigurationSerialization.registerClass(clazz);
        }
    }
}

