/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.proxy;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.magmafoundation.magma.remapper.proxy.ProxyClass;
import org.magmafoundation.magma.remapper.proxy.ProxyClassLoader;
import org.magmafoundation.magma.remapper.utils.RemappingUtils;

public class ProxyMethodHandles_Lookup {
    public static MethodHandle findVirtual(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        if (clazz.getName().startsWith("net.minecraft.")) {
            name = RemappingUtils.mapMethodName(clazz, name, type);
        } else if (clazz == Class.class) {
            switch (name) {
                case "getField": 
                case "getDeclaredField": 
                case "getMethod": 
                case "getDeclaredMethod": {
                    type = MethodType.methodType(type.returnType(), new Class[]{Class.class, String.class});
                    clazz = ProxyClass.class;
                    break;
                }
            }
        } else if (clazz == ClassLoader.class && name.equals("loadClass")) {
            type = MethodType.methodType(type.returnType(), new Class[]{ClassLoader.class, String.class});
            clazz = ProxyClassLoader.class;
        }
        return lookup.findVirtual(clazz, name, type);
    }

    public static MethodHandle findStatic(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        if (clazz.getName().startsWith("net.minecraft.")) {
            name = RemappingUtils.mapMethodName(clazz, name, type);
        } else if (clazz == Class.class && name.equals("forName")) {
            clazz = ProxyClass.class;
        }
        return lookup.findStatic(clazz, name, type);
    }

    public static MethodHandle findSpecial(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
        if (clazz.getName().startsWith("net.minecraft.")) {
            name = RemappingUtils.mapMethodName(clazz, name, type);
        }
        return lookup.findSpecial(clazz, name, type, specialCaller);
    }

    public static MethodHandle unreflect(MethodHandles.Lookup lookup, Method m2) throws IllegalAccessException, NoSuchMethodException {
        if (m2.getDeclaringClass() == Class.class) {
            String name;
            switch (name = m2.getName()) {
                case "forName": {
                    return lookup.unreflect(ProxyClass.class.getMethod(name, String.class));
                }
                case "getField": 
                case "getDeclaredField": {
                    return lookup.unreflect(ProxyClass.class.getMethod(name, Class.class, String.class));
                }
                case "getMethod": 
                case "getDeclaredMethod": {
                    return lookup.unreflect(ProxyClass.class.getMethod(name, Class.class, String.class, Class[].class));
                }
            }
        } else if (m2.getDeclaringClass() == ClassLoader.class && m2.getName().equals("loadClass")) {
            return lookup.unreflect(ClassLoader.class.getMethod(m2.getName(), ClassLoader.class, String.class));
        }
        return lookup.unreflect(m2);
    }
}

