/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.remappers;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.md_5.specialsource.provider.InheritanceProvider;
import org.magmafoundation.magma.remapper.remappers.MagmaClassRepo;
import org.magmafoundation.magma.remapper.utils.RemappingUtils;
import org.objectweb.asm.tree.ClassNode;

public class MagmaInheritanceProvider
implements InheritanceProvider {
    public Set<String> getParents(String className) {
        if (className.startsWith("org/springframework/")) {
            return null;
        }
        return this.fineParents(className, true);
    }

    protected Set<String> fineParents(String className, boolean remap) {
        if (className.startsWith("net/minecraft/")) {
            return this.fineNMSParents(className, remap);
        }
        return this.findNormalParents(className, remap);
    }

    protected Set<String> fineNMSParents(String className, boolean remap) {
        if (remap) {
            className = RemappingUtils.map(className);
        }
        HashSet<String> parents = new HashSet<String>();
        try {
            Class<?> reference = Class.forName(className.replace('/', '.').replace('$', '.'), false, this.getClass().getClassLoader());
            Class<?> extend = reference.getSuperclass();
            if (extend != null) {
                parents.add(RemappingUtils.reverseMap(extend));
            }
            for (Class<?> inter : reference.getInterfaces()) {
                if (inter == null) continue;
                parents.add(RemappingUtils.reverseMap(inter));
            }
            return parents;
        }
        catch (Exception exception) {
            return parents;
        }
    }

    protected Set<String> findNormalParents(String className, boolean remap) {
        ClassNode cn = MagmaClassRepo.getInstance().findClass(className);
        if (cn == null) {
            if (!remap) {
                return null;
            }
            String remapClassName = RemappingUtils.map(className);
            if (Objects.equals(remapClassName, className)) {
                return null;
            }
            return this.fineParents(remapClassName, false);
        }
        HashSet<String> parents = new HashSet<String>();
        if (cn.superName != null) {
            parents.add(RemappingUtils.reverseMap(cn.superName));
        }
        if (cn.interfaces != null) {
            for (String anInterface : cn.interfaces) {
                parents.add(RemappingUtils.reverseMap(anInterface));
            }
        }
        return parents.isEmpty() ? null : parents;
    }
}

