/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.remappers;

import java.util.Map;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import org.magmafoundation.magma.remapper.mappingsModel.ClassMappings;
import org.magmafoundation.magma.remapper.remappers.MagmaJarMapping;
import org.magmafoundation.magma.remapper.utils.ASMUtils;

public class MagmaJarRemapper
extends CustomRemapper {
    public final MagmaJarMapping jarMapping;

    public MagmaJarRemapper(MagmaJarMapping jarMapping) {
        this.jarMapping = jarMapping;
    }

    public static String mapTypeName(String typeName, Map<String, String> packageMap, Map<String, ClassMappings> classMap, String defaultIfUnmapped) {
        String mapped = MagmaJarRemapper.mapClassName(typeName, packageMap, classMap);
        return mapped != null ? mapped : defaultIfUnmapped;
    }

    private static String mapClassName(String className, Map<String, String> packageMap, Map<String, ClassMappings> classMap) {
        if (classMap != null && classMap.containsKey(className)) {
            ClassMappings mapping = classMap.get(className);
            return mapping.getMcpSrcName();
        }
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String outer = className.substring(0, index);
            String mapped = MagmaJarRemapper.mapClassName(outer, packageMap, classMap);
            if (mapped == null) {
                return null;
            }
            return mapped + className.substring(index);
        }
        if (packageMap != null) {
            for (String oldPackage : packageMap.keySet()) {
                if (!MagmaJarRemapper.matchClassPackage(oldPackage, className)) continue;
                String newPackage = packageMap.get(oldPackage);
                return MagmaJarRemapper.moveClassPackage(newPackage, MagmaJarRemapper.getSimpleName(oldPackage, className));
            }
        }
        return null;
    }

    private static boolean matchClassPackage(String packageName, String className) {
        if (packageName.equals(".")) {
            return MagmaJarRemapper.isDefaultPackage(className);
        }
        return className.startsWith(packageName);
    }

    private static String moveClassPackage(String packageName, String classSimpleName) {
        if (packageName.equals(".")) {
            return classSimpleName;
        }
        return packageName + classSimpleName;
    }

    private static boolean isDefaultPackage(String className) {
        return className.indexOf(47) == -1;
    }

    private static String getSimpleName(String oldPackage, String className) {
        if (oldPackage.equals(".")) {
            return className;
        }
        return className.substring(oldPackage.length());
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (ASMUtils.isValidSingnature(signature)) {
            return super.mapSignature(signature, typeSignature);
        }
        return signature;
    }

    public String map(String typeName) {
        return MagmaJarRemapper.mapTypeName(typeName, this.jarMapping.packages, this.jarMapping.byNMSSrcName, typeName);
    }

    public String mapFieldName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.fields, NodeType.FIELD, owner, name, access);
        return mapped == null ? name : mapped;
    }

    public String mapMethodName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.methods, NodeType.METHOD, owner, name + " " + desc, access);
        return mapped == null ? name : mapped;
    }
}

