/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.remappers;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.remapper.inter.ClassRemapperSupplier;
import org.magmafoundation.magma.remapper.utils.ASMUtils;
import org.objectweb.asm.commons.Remapper;

public class NMSVersionRemapper
extends Remapper
implements ClassRemapperSupplier {
    private static final String targetVersion = Magma.getBukkitVersion();
    private static final Pattern cbPattern = Pattern.compile("org/bukkit/craftbukkit/(v\\d_\\d+_R\\d)/[\\w/]+");
    private static final Pattern nmsPattern = Pattern.compile("net/minecraft/server/(v\\d_\\d+_R\\d)/[\\w/]+");

    public String map(String typeName) {
        String str = typeName;
        Matcher m2 = cbPattern.matcher(str);
        if (m2.find()) {
            String srcVersion = m2.group(1);
            if (!Objects.equals(srcVersion, targetVersion)) {
                str = str.replace(srcVersion, targetVersion);
            }
        } else {
            String srcVersion;
            m2 = nmsPattern.matcher(typeName);
            if (m2.find() && !Objects.equals(srcVersion = m2.group(1), targetVersion)) {
                str = str.replace(srcVersion, targetVersion);
            }
        }
        return str;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (ASMUtils.isValidSingnature(signature)) {
            return super.mapSignature(signature, typeSignature);
        }
        return signature;
    }
}

