/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.remappers;

import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.magmafoundation.magma.remapper.mappingsModel.MethodRedirectRule;
import org.magmafoundation.magma.remapper.proxy.DelegateURLClassLoder;
import org.magmafoundation.magma.remapper.proxy.ProxyClass;
import org.magmafoundation.magma.remapper.proxy.ProxyClassLoader;
import org.magmafoundation.magma.remapper.proxy.ProxyClassWriter;
import org.magmafoundation.magma.remapper.proxy.ProxyField;
import org.magmafoundation.magma.remapper.proxy.ProxyMethod;
import org.magmafoundation.magma.remapper.proxy.ProxyMethodHandles_Lookup;
import org.magmafoundation.magma.remapper.proxy.ProxyMethodType;
import org.magmafoundation.magma.remapper.proxy.ProxyYamlConfiguration;
import org.magmafoundation.magma.remapper.utils.ASMUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

public class ReflectionMethodRemapper
extends MethodRemapper {
    private static Map<String, Map<String, Map<String, MethodRedirectRule>>> methodRedirectMapping = new HashMap<String, Map<String, Map<String, MethodRedirectRule>>>();

    public ReflectionMethodRemapper(MethodVisitor mv, Remapper remapper) {
        super(mv, remapper);
    }

    public ReflectionMethodRemapper(int api2, MethodVisitor mv, Remapper remapper) {
        super(api2, mv, remapper);
    }

    private static void registerMethodRemapper(String owner, String name, Class returnType, Class[] args, Class remapOwner) {
        Map byName = methodRedirectMapping.computeIfAbsent(owner, k2 -> new HashMap());
        Map byDesc = byName.computeIfAbsent(name, k2 -> new HashMap());
        String methodDescriptor = ASMUtils.toMethodDescriptor(returnType, args);
        byDesc.put(methodDescriptor, new MethodRedirectRule(owner, name, methodDescriptor, remapOwner.getName().replace('.', '/')));
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187 && "java/net/URLClassLoader".equals(type)) {
            type = DelegateURLClassLoder.desc;
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (182 == opcode) {
            this.redirectVirtual(opcode, owner, name, desc, itf);
        } else if (184 == opcode) {
            this.redirectStatic(opcode, owner, name, desc, itf);
        } else if (183 == opcode) {
            this.redirectSpecial(opcode, owner, name, desc, itf);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private MethodRedirectRule findRule(int opcode, String owner, String name, String desc, boolean itf) {
        Map<String, Map<String, MethodRedirectRule>> byOwner = methodRedirectMapping.get(owner);
        if (byOwner == null) {
            return null;
        }
        Map<String, MethodRedirectRule> byName = byOwner.get(name);
        if (byName == null) {
            return null;
        }
        MethodRedirectRule rule = byName.get(desc);
        return rule;
    }

    private void redirectSpecial(int opcode, String owner, String name, String desc, boolean itf) {
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            owner = rule.getRemapOwner();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void redirectVirtual(int opcode, String owner, String name, String desc, boolean itf) {
        if (desc.equals("()[B") && name.equals("toByteArray") && owner.equals("com/comphenix/net/sf/cglib/asm/$ClassWriter")) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            super.visitMethodInsn(184, ProxyClassWriter.class.getName().replace('.', '/'), "remapClass", "([B)[B", false);
            return;
        }
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            opcode = 184;
            Type r2 = Type.getReturnType((String)desc);
            Type[] args = Type.getArgumentTypes((String)desc);
            Type[] newArgs = new Type[args.length + 1];
            newArgs[0] = "org/magmafoundation/magma/remapper/proxy/ProxyClassLoader".equals(rule.getRemapOwner()) && "loadClass".equals(name) ? Type.getObjectType((String)"java/lang/ClassLoader") : Type.getObjectType((String)owner);
            owner = rule.getRemapOwner();
            System.arraycopy(args, 0, newArgs, 1, args.length);
            desc = Type.getMethodDescriptor((Type)r2, (Type[])newArgs);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private void redirectStatic(int opcode, String owner, String name, String desc, boolean itf) {
        MethodRedirectRule rule = this.findRule(opcode, owner, name, desc, itf);
        if (rule != null) {
            owner = rule.getRemapOwner();
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    static {
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "forName", Class.class, new Class[]{String.class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "forName", Class.class, new Class[]{String.class, Boolean.TYPE, ClassLoader.class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getField", Field.class, new Class[]{String.class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getDeclaredField", Field.class, new Class[]{String.class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getMethod", Method.class, new Class[]{String.class, Class[].class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getDeclaredMethod", Method.class, new Class[]{String.class, Class[].class}, ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getName", String.class, new Class[0], ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/Class", "getSimpleName", String.class, new Class[0], ProxyClass.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/reflect/Method", "getName", String.class, new Class[0], ProxyMethod.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/reflect/Field", "getName", String.class, new Class[0], ProxyField.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodType", "fromMethodDescriptorString", MethodType.class, new Class[]{String.class, ClassLoader.class}, ProxyMethodType.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodHandles$Lookup", "unreflect", MethodHandle.class, new Class[]{String.class, ClassLoader.class}, ProxyMethodHandles_Lookup.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodHandles$Lookup", "findSpecial", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class, Class.class}, ProxyMethodHandles_Lookup.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodHandles$Lookup", "findStatic", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class}, ProxyMethodHandles_Lookup.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodHandles$Lookup", "findVirtual", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class}, ProxyMethodHandles_Lookup.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/invoke/MethodHandles$Lookup", "findVirtual", MethodHandle.class, new Class[]{Class.class, String.class, MethodType.class}, ProxyMethodHandles_Lookup.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/lang/ClassLoader", "loadClass", Class.class, new Class[]{String.class}, ProxyClassLoader.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/net/URLClassLoader", "loadClass", Class.class, new Class[]{String.class}, ProxyClassLoader.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/net/URLClassLoader", "<init>", Void.TYPE, new Class[]{URL[].class, ClassLoader.class, URLStreamHandlerFactory.class}, DelegateURLClassLoder.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/net/URLClassLoader", "<init>", Void.TYPE, new Class[]{URL[].class, ClassLoader.class}, DelegateURLClassLoder.class);
        ReflectionMethodRemapper.registerMethodRemapper("java/net/URLClassLoader", "<init>", Void.TYPE, new Class[]{URL[].class}, DelegateURLClassLoder.class);
        ReflectionMethodRemapper.registerMethodRemapper("org/bukkit/configuration/file/YamlConfiguration", "loadConfiguration", YamlConfiguration.class, new Class[]{InputStream.class}, ProxyYamlConfiguration.class);
    }
}

