/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.remapper.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import org.bukkit.plugin.PluginDescriptionFile;
import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.remapper.RemapContext;
import org.magmafoundation.magma.remapper.inter.ClassRemapperSupplier;
import org.magmafoundation.magma.remapper.mappingsModel.ClassMappings;
import org.magmafoundation.magma.remapper.remappers.MagmaInheritanceMap;
import org.magmafoundation.magma.remapper.remappers.MagmaInheritanceProvider;
import org.magmafoundation.magma.remapper.remappers.MagmaJarMapping;
import org.magmafoundation.magma.remapper.remappers.MagmaJarRemapper;
import org.magmafoundation.magma.remapper.remappers.NMSVersionRemapper;
import org.magmafoundation.magma.remapper.remappers.ReflectionRemapper;
import org.magmafoundation.magma.remapper.utils.ASMUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;

public class RemappingUtils {
    public static final String nmsPrefix = "net.minecraft.server.";
    public static final MagmaJarMapping jarMapping;
    private static final List<Remapper> remappers;
    private static final Object remapLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] remapFindClass(PluginDescriptionFile description, String name, byte[] bs) throws IOException {
        Object object = remapLock;
        synchronized (object) {
            ClassNode classNode = new ClassNode();
            new ClassReader(bs).accept((ClassVisitor)classNode, 8);
            for (Remapper remapper : remappers) {
                if (description != null && remapper instanceof NMSVersionRemapper) continue;
                try {
                    RemapContext.push(new RemapContext().setClassNode(classNode).setDescription(description));
                    ClassNode container = new ClassNode();
                    ClassRemapper classRemapper = remapper instanceof ClassRemapperSupplier ? ((ClassRemapperSupplier)remapper).getClassRemapper((ClassVisitor)container) : new ClassRemapper((ClassVisitor)container, remapper);
                    classNode.accept((ClassVisitor)classRemapper);
                    classNode = container;
                }
                finally {
                    RemapContext.pop();
                }
            }
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bs = writer.toByteArray();
            return bs;
        }
    }

    public static String map(String typeName) {
        typeName = RemappingUtils.mapPackage(typeName);
        return RemappingUtils.jarMapping.classes.getOrDefault(typeName, typeName);
    }

    public static String reverseMap(String typeName) {
        ClassMappings mapping = RemappingUtils.jarMapping.byNMSInternalName.get(typeName);
        return mapping == null ? typeName : mapping.getNmsSrcName();
    }

    public static String reverseMap(Class clazz) {
        ClassMappings mapping = RemappingUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? ASMUtils.toInternalName(clazz) : mapping.getNmsSrcName();
    }

    public static String mapPackage(String typeName) {
        for (Map.Entry<String, String> entry : RemappingUtils.jarMapping.packages.entrySet()) {
            String prefix = entry.getKey();
            if (!typeName.startsWith(prefix)) continue;
            return entry.getValue() + typeName.substring(prefix.length());
        }
        return typeName;
    }

    public static String remapMethodDesc(String methodDescriptor) {
        Type rt = Type.getReturnType((String)methodDescriptor);
        Type[] ts = Type.getArgumentTypes((String)methodDescriptor);
        rt = Type.getType((String)ASMUtils.toDescriptorV2(RemappingUtils.map(ASMUtils.getInternalName(rt))));
        for (int i2 = 0; i2 < ts.length; ++i2) {
            ts[i2] = Type.getType((String)ASMUtils.toDescriptorV2(RemappingUtils.map(ASMUtils.getInternalName(ts[i2]))));
        }
        return Type.getMethodType((Type)rt, (Type[])ts).getDescriptor();
    }

    public static String mapMethodName(Class clazz, String name, MethodType methodType) {
        return RemappingUtils.mapMethodName(clazz, name, methodType.parameterArray());
    }

    public static String mapMethodName(Class type, String name, Class<?> ... parameterTypes) {
        return jarMapping.fastMapMethodName(type, name, parameterTypes);
    }

    public static String inverseMapMethodName(Class type, String name, Class<?> ... parameterTypes) {
        return jarMapping.fastReverseMapMethodName(type, name, parameterTypes);
    }

    public static String mapFieldName(Class type, String fieldName) {
        return jarMapping.fastMapFieldName(type, fieldName);
    }

    public static String inverseMapFieldName(Class type, String fieldName) {
        return jarMapping.fastReverseMapFieldName(type, fieldName);
    }

    public static String inverseMapName(Class clazz) {
        ClassMappings mapping = RemappingUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getName() : mapping.getNmsName();
    }

    public static String inverseMapSimpleName(Class clazz) {
        ClassMappings mapping = RemappingUtils.jarMapping.byMCPName.get(clazz.getName());
        return mapping == null ? clazz.getSimpleName() : mapping.getNmsSimpleName();
    }

    static {
        remappers = new ArrayList<Remapper>();
        remapLock = new Object();
        jarMapping = new MagmaJarMapping();
        RemappingUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/it/unimi/dsi/fastutil/", "it/unimi/dsi/fastutil/");
        RemappingUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/jline/", "jline/");
        RemappingUtils.jarMapping.packages.put("org/bukkit/craftbukkit/libs/joptsimple/", "joptsimple/");
        RemappingUtils.jarMapping.classes.put("catserver/api/bukkit/event/ForgeEvent", "org/magmafoundation/magma/api/events/ForgeEvents");
        jarMapping.registerFieldMapping("catserver/api/bukkit/event/ForgeEvent", "handlers", "org/magmafoundation/magma/api/events/ForgeEvent", "handlers");
        jarMapping.registerFieldMapping("catserver/api/bukkit/event/ForgeEvent", "forgeEvent", "org/magmafoundation/magma/api/events/ForgeEvent", "forgeEvent");
        jarMapping.registerMethodMapping("org/bukkit/Bukkit", "getOnlinePlayers", "()[Lorg/bukkit/entity/Player;", "org/bukkit/Bukkit", "_INVALID_getOnlinePlayers", "()[Lorg/bukkit/entity/Player;");
        jarMapping.registerMethodMapping("org/bukkit/Server", "getOnlinePlayers", "()[Lorg/bukkit/entity/Player;", "org/bukkit/Server", "_INVALID_getOnlinePlayers", "()[Lorg/bukkit/entity/Player;");
        jarMapping.registerMethodMapping("org/bukkit/craftbukkit/" + Magma.getBukkitVersion() + "/CraftServer", "getOnlinePlayers", "()[Lorg/bukkit/entity/Player;", "org/bukkit/craftbukkit/" + Magma.getBukkitVersion() + "/CraftServer", "_INVALID_getOnlinePlayers", "()[Lorg/bukkit/entity/Player;");
        jarMapping.registerMethodMapping("catserver/api/bukkit/event/ForgeEvent", "getForgeEvent", "()Lnet/minecraftforge/fml/common/eventhandler/Event;", "org/magmafoundation/magma/api/events/ForgeEvent", "getForgeEvent", "()Lnet/minecraftforge/fml/common/eventhandler/Event;");
        jarMapping.setInheritanceMap(new MagmaInheritanceMap());
        jarMapping.setFallbackInheritanceProvider(new MagmaInheritanceProvider());
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("net.minecraft.server", nmsPrefix + Magma.getBukkitVersion());
        try {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(Magma.class.getClassLoader().getResourceAsStream("mappings/NMSMappings.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        remappers.add(new NMSVersionRemapper());
        MagmaJarRemapper jarRemapper = new MagmaJarRemapper(jarMapping);
        remappers.add((Remapper)jarRemapper);
        remappers.add(new ReflectionRemapper());
        jarMapping.initFastMethodMapping((Remapper)jarRemapper);
    }
}

