/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class TimedEventExecutor
implements EventExecutor {
    private final EventExecutor executor;
    private final Timing timings;

    public TimedEventExecutor(EventExecutor executor, Plugin plugin, Method method, Class<? extends Event> eventClass) {
        this.executor = executor;
        if (method == null && executor.getClass().getEnclosingClass() != null) {
            method = executor.getClass().getEnclosingMethod();
        }
        String id = method != null ? method.getDeclaringClass().getName() : executor.getClass().getName();
        String eventName = eventClass.getSimpleName();
        boolean verbose = "BlockPhysicsEvent".equals(eventName);
        this.timings = Timings.ofSafe(plugin.getName(), (verbose ? "## " : "") + "Event: " + id + " (" + eventName + ")", null);
    }

    @Override
    public void execute(Listener listener, Event event) throws EventException {
        if (event.isAsynchronous() || !Timings.timingsEnabled || !Bukkit.isPrimaryThread()) {
            this.executor.execute(listener, event);
            return;
        }
        try (Timing ignored = this.timings.startTiming();){
            this.executor.execute(listener, event);
        }
    }
}

