/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.util.LoadingIntMap;
import com.mohistmc.util.i18n.Message;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

class TimingHandler
implements Timing {
    private static AtomicInteger idPool = new AtomicInteger(1);
    static Deque<TimingHandler> TIMING_STACK = new ArrayDeque<TimingHandler>();
    final int id = idPool.getAndIncrement();
    final TimingIdentifier identifier;
    private final boolean verbose;
    private final Int2ObjectOpenHashMap<TimingData> children = new LoadingIntMap<TimingData>(TimingData::new);
    final TimingData record;
    private final TimingHandler groupHandler;
    private long start = 0L;
    private int timingDepth = 0;
    private boolean added;
    private boolean timed;
    private boolean enabled;

    TimingHandler(TimingIdentifier id) {
        this.identifier = id;
        this.verbose = id.name.startsWith("##");
        this.record = new TimingData(this.id);
        this.groupHandler = id.groupHandler;
        TimingIdentifier.getGroup((String)id.group).handlers.add(this);
        this.checkEnabled();
    }

    final void checkEnabled() {
        this.enabled = Timings.timingsEnabled && (!this.verbose || Timings.verboseEnabled);
    }

    void processTick(boolean violated) {
        if (this.timingDepth != 0 || this.record.getCurTickCount() == 0) {
            this.timingDepth = 0;
            this.start = 0L;
            return;
        }
        this.record.processTick(violated);
        for (TimingData handler : this.children.values()) {
            handler.processTick(violated);
        }
    }

    @Override
    public Timing startTimingIfSync() {
        this.startTiming();
        return this;
    }

    @Override
    public void stopTimingIfSync() {
        this.stopTiming();
    }

    @Override
    public Timing startTiming() {
        if (this.enabled && Bukkit.isPrimaryThread() && ++this.timingDepth == 1) {
            this.start = System.nanoTime();
            TIMING_STACK.addLast(this);
        }
        return this;
    }

    @Override
    public void stopTiming() {
        if (this.enabled && this.timingDepth > 0 && Bukkit.isPrimaryThread() && --this.timingDepth == 0 && this.start != 0L) {
            TimingHandler last;
            while ((last = TIMING_STACK.removeLast()) != this) {
                last.timingDepth = 0;
                String reportTo = "minecraft".equals(last.identifier.group) ? Message.getString("timings.handler.1") : Message.getFormatString("timings.handler.2", new Object[]{last.identifier.group});
                Logger.getGlobal().log(Level.SEVERE, Message.getFormatString("timings.handler.3", new Object[]{reportTo, last.identifier}), new Throwable());
            }
            this.addDiff(System.nanoTime() - this.start, TIMING_STACK.peekLast());
            this.start = 0L;
        }
    }

    @Override
    public final void abort() {
    }

    void addDiff(long diff, TimingHandler parent) {
        if (parent != null) {
            ((TimingData)parent.children.get(this.id)).add(diff);
        }
        this.record.add(diff);
        if (!this.added) {
            this.added = true;
            this.timed = true;
            TimingsManager.HANDLERS.add(this);
        }
        if (this.groupHandler != null) {
            this.groupHandler.addDiff(diff, parent);
            ((TimingData)this.groupHandler.children.get(this.id)).add(diff);
        }
    }

    void reset(boolean full) {
        this.record.reset();
        if (full) {
            this.timed = false;
        }
        this.start = 0L;
        this.timingDepth = 0;
        this.added = false;
        this.children.clear();
        this.checkEnabled();
    }

    @Override
    public TimingHandler getTimingHandler() {
        return this;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public void close() {
        this.stopTimingIfSync();
    }

    public boolean isSpecial() {
        return this == TimingsManager.FULL_SERVER_TICK || this == TimingsManager.TIMINGS_TICK;
    }

    boolean isTimed() {
        return this.timed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    TimingData[] cloneChildren() {
        TimingData[] clonedChildren = new TimingData[this.children.size()];
        int i = 0;
        for (TimingData child : this.children.values()) {
            clonedChildren[i++] = child.clone();
        }
        return clonedChildren;
    }
}

