/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.MohistMC;
import com.mohistmc.util.i18n.Message;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;

public class MohistThreadCost {
    static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public MohistThreadCost() {
        threadMXBean.setThreadCpuTimeEnabled(true);
    }

    public static void dumpThreadCpuTime() {
        ArrayList<ThreadCpuTime> list = new ArrayList<ThreadCpuTime>();
        long[] ids = threadMXBean.getAllThreadIds();
        for (long id : ids) {
            ThreadCpuTime item = new ThreadCpuTime();
            item.cpuTime = MohistThreadCost.threadMXBean.getThreadCpuTime(id) / 1000000L;
            item.userTime = MohistThreadCost.threadMXBean.getThreadUserTime(id) / 1000000L;
            item.name = MohistThreadCost.threadMXBean.getThreadInfo(id).getThreadName();
            item.id = id;
            list.add(item);
        }
        list.sort(Comparator.comparingLong(i2 -> ((ThreadCpuTime)i2).id));
        MohistMC.LOGGER.info(Message.getString("mohist.dump.1"));
        Object object = list.iterator();
        while (object.hasNext()) {
            ThreadCpuTime threadCpuTime = (ThreadCpuTime)object.next();
            MohistMC.LOGGER.info(String.format("%s %s %s %s", threadCpuTime.id, threadCpuTime.name, threadCpuTime.cpuTime, threadCpuTime.userTime));
        }
    }

    public static class ThreadCpuTime {
        private long id;
        private long cpuTime;
        private long userTime;
        private String name;
    }
}

