/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemAPI {
    public static Map<String, String> MODNAME_MAP = new ConcurrentHashMap<String, String>();
    public static Map<Integer, String> MODID_MAP = new ConcurrentHashMap<Integer, String>();

    public static aip toNMSItem(Material materialcb) {
        ItemStack itemStackcb = new ItemStack(materialcb);
        return CraftItemStack.asNMSCopy(itemStackcb);
    }

    public static ItemStack getBukkit(Material material) {
        return CraftItemStack.asBukkitCopy(ItemAPI.toNMSItem(material));
    }

    public static ItemStack Base64ToBukkit(String base64) throws IOException {
        ItemStack itemStack;
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream(new ByteArrayInputStream(Base64Coder.decodeLines((String)base64)));
        try {
            itemStack = (ItemStack)dataInput.readObject();
        }
        catch (Throwable throwable) {
            try {
                dataInput.close();
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IOException("Unable to decode class type.", e);
            }
        }
        dataInput.close();
        return itemStack;
    }

    public static String BukkitToBase64(ItemStack stack) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream(outputStream);
            dataOutput.writeObject(stack);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stack.", e);
        }
    }

    public static ItemStack NBTBase64ToBukkit(String base64) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(Base64Coder.decodeLines((String)base64)));
        fy tag = new fy();
        try {
            tag.read0((DataInput)input, 0, gh.a);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        aip handle = new aip(tag);
        return CraftItemStack.asBukkitCopy(handle);
    }

    public static String BukkitToNBTBase64(ItemStack stack) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            CraftItemStack copy = CraftItemStack.asCraftCopy(stack);
            fy tag = new fy();
            copy.getHandle().a(tag);
            tag.write0((DataOutput)new DataOutputStream(out));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64Coder.encodeLines((byte[])out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getNBTBytes(ItemStack iStack) {
        try {
            aip is = CraftItemStack.asNMSCopy(iStack);
            fy itemCompound = new fy();
            itemCompound = is.a(itemCompound);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try (DataOutputStream dataOut = new DataOutputStream(new GZIPOutputStream(byteOut));){
                gi.a((fy)itemCompound, (OutputStream)dataOut);
            }
            return byteOut.toByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static ItemStack getItemStackInNBTBytes(byte[] bytes) {
        try {
            fy tag;
            try (DataInputStream dataIn = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes))));){
                tag = gi.a((DataInput)dataIn, null);
            }
            aip is = new aip(tag);
            return CraftItemStack.asBukkitCopy(is);
        }
        catch (Exception e) {
            return new ItemStack(Material.AIR);
        }
    }

    public static String serializeNBT(fy nbtTagCompound) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            gi.a((fy)nbtTagCompound, (OutputStream)buf);
            return Base64Coder.encodeLines((byte[])buf.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static fy deserializeNBT(String serializeNBT) {
        if (serializeNBT != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64Coder.decodeLines((String)serializeNBT));
            try {
                return gi.a((InputStream)buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Material getBlockMaterial(int id) {
        return Material.getBlockMaterial(id);
    }

    public static String getModid(String name) {
        return MODNAME_MAP.containsKey(name) ? MODNAME_MAP.get(name) : "unknown";
    }

    public static String getModid(int id) {
        return MODNAME_MAP.containsKey(id) ? MODNAME_MAP.get(id) : "unknown";
    }
}

