/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api.filestream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NBT {
    public static Map<String, Object> read(InputStream in2) throws IOException {
        return NBT.read(in2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> read(InputStream in2, boolean compressed) throws IOException {
        try (DataInputStream data = compressed ? new DataInputStream(new GZIPInputStream(in2)) : new DataInputStream(new BufferedInputStream(in2));){
            Map<String, Object> map = NBT.read(data);
            return map;
        }
    }

    public static void write(OutputStream out, Map<String, Object> map) throws IOException {
        NBT.write(out, map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out, Map<String, Object> map, boolean compressed) throws IOException {
        try (DataOutputStream data = compressed ? new DataOutputStream(new GZIPOutputStream(out)) : new DataOutputStream(new BufferedOutputStream(out));){
            NBT.write(data, map);
        }
    }

    private static Map<String, Object> read(DataInput in2) throws IOException {
        if (in2.readByte() != 10) {
            throw new IOException("Root tag must be a named compound tag");
        }
        String name = NBT.readString(in2);
        Map<String, Object> map = NBT.readCompound(in2);
        if (!name.isEmpty()) {
            map.put("$this.name", name);
        }
        return map;
    }

    private static Object readTag(DataInput in2, byte type) throws IOException {
        switch (type) {
            case 1: {
                return in2.readByte();
            }
            case 2: {
                return in2.readShort();
            }
            case 3: {
                return in2.readInt();
            }
            case 4: {
                return in2.readLong();
            }
            case 5: {
                return Float.valueOf(in2.readFloat());
            }
            case 6: {
                return in2.readDouble();
            }
            case 7: {
                return NBT.readByteArray(in2);
            }
            case 8: {
                return NBT.readString(in2);
            }
            case 9: {
                return NBT.readList(in2);
            }
            case 10: {
                return NBT.readCompound(in2);
            }
            case 11: {
                return NBT.readIntArray(in2);
            }
        }
        throw new IOException("Invalid NBT tag type (1-10): " + type);
    }

    private static int[] readIntArray(DataInput in2) throws IOException {
        int[] data = new int[in2.readInt()];
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = in2.readInt();
        }
        return data;
    }

    private static byte[] readByteArray(DataInput in2) throws IOException {
        byte[] data = new byte[in2.readInt()];
        in2.readFully(data);
        return data;
    }

    private static String readString(DataInput in2) throws IOException {
        return in2.readUTF();
    }

    private static List<Object> readList(DataInput in2) throws IOException {
        byte type = in2.readByte();
        int length = in2.readInt();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            Object tag = NBT.readTag(in2, type);
            list.add(tag);
        }
        return list;
    }

    private static Map<String, Object> readCompound(DataInput in2) throws IOException {
        byte type;
        HashMap<String, Object> map = new HashMap<String, Object>();
        while ((type = in2.readByte()) != 0) {
            String name = NBT.readString(in2);
            Object tag = NBT.readTag(in2, type);
            map.put(name, tag);
        }
        return map;
    }

    private static byte whichType(Object tag) {
        if (tag instanceof Byte) {
            return 1;
        }
        if (tag instanceof Short) {
            return 2;
        }
        if (tag instanceof Integer) {
            return 3;
        }
        if (tag instanceof Long) {
            return 4;
        }
        if (tag instanceof Float) {
            return 5;
        }
        if (tag instanceof Double) {
            return 6;
        }
        if (tag instanceof byte[]) {
            return 7;
        }
        if (tag instanceof String) {
            return 8;
        }
        if (tag instanceof List) {
            return 9;
        }
        if (tag instanceof Map) {
            return 10;
        }
        if (tag instanceof int[]) {
            return 11;
        }
        throw new RuntimeException("Cannot serialize unknown type " + tag.getClass());
    }

    private static void writeTag(DataOutput out, byte type, Object tag) throws IOException {
        switch (type) {
            case 1: {
                out.writeByte(((Byte)tag).byteValue());
                break;
            }
            case 2: {
                out.writeShort(((Short)tag).shortValue());
                break;
            }
            case 3: {
                out.writeInt((Integer)tag);
                break;
            }
            case 4: {
                out.writeLong((Long)tag);
                break;
            }
            case 5: {
                out.writeFloat(((Float)tag).floatValue());
                break;
            }
            case 6: {
                out.writeDouble((Double)tag);
                break;
            }
            case 7: {
                NBT.writeByteArray(out, (byte[])tag);
                break;
            }
            case 8: {
                NBT.writeString(out, (String)tag);
                break;
            }
            case 9: {
                NBT.writeList(out, (List)tag);
                break;
            }
            case 10: {
                NBT.writeCompound(out, (Map)tag);
                break;
            }
            case 11: {
                NBT.writeIntArray(out, (int[])tag);
                break;
            }
            default: {
                throw new IOException("Invalid NBT tag type (1-11): " + type);
            }
        }
    }

    private static void writeByteArray(DataOutput out, byte[] array) throws IOException {
        out.writeInt(array.length);
        out.write(array);
    }

    private static void writeIntArray(DataOutput out, int[] array) throws IOException {
        out.writeInt(array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            out.writeInt(array[i2]);
        }
    }

    private static void writeString(DataOutput out, String str) throws IOException {
        out.writeUTF(str);
    }

    private static void writeList(DataOutput out, List<Object> list) throws IOException {
        byte type = list.isEmpty() ? (byte)1 : NBT.whichType(list.get(0));
        out.writeByte(type);
        out.writeInt(list.size());
        for (Object tag : list) {
            NBT.writeTag(out, type, tag);
        }
    }

    private static void writeCompound(DataOutput out, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("$this.name")) continue;
            byte type = NBT.whichType(entry.getValue());
            out.writeByte(type);
            NBT.writeString(out, entry.getKey());
            NBT.writeTag(out, type, entry.getValue());
        }
        out.writeByte(0);
    }
}

