/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.api.world.WorldNoiseGenerator;

import java.util.Random;

public class Voronoi {
    private final float[][][][][] grid;
    private final Random r;
    private final int density;
    private final int size;
    private final int zsize;
    private final int dimensions;
    private final boolean is2D;
    private final DistanceMetric metric;
    private final int level;
    static final int[][] order3D = new int[][]{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {-1, 0, 0}, {0, -1, 0}, {0, 0, -1}, {1, 1, 0}, {1, 0, 1}, {0, 1, 1}, {-1, 1, 0}, {-1, 0, 1}, {0, -1, 1}, {1, -1, 0}, {1, 0, -1}, {0, 1, -1}, {-1, -1, 0}, {-1, 0, -1}, {0, -1, -1}, {1, 1, 1}, {-1, 1, 1}, {1, -1, 1}, {1, 1, -1}, {-1, -1, 1}, {-1, 1, -1}, {1, -1, -1}, {-1, -1, -1}};
    static final int[][] order2D = new int[][]{{0, 0}, {1, 0}, {0, 1}, {-1, 0}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}};

    public Voronoi(int size, boolean is2D, long seed, int density, DistanceMetric metric, int level) {
        this.zsize = is2D ? 1 : size;
        this.dimensions = is2D ? 2 : 3;
        this.grid = new float[size][size][this.zsize][density][this.dimensions];
        this.r = new Random(seed);
        this.size = size;
        this.density = density;
        this.metric = metric;
        this.level = level;
        this.is2D = is2D;
        for (int i2 = 0; i2 < size; ++i2) {
            for (int j = 0; j < size; ++j) {
                for (int k = 0; k < this.zsize; ++k) {
                    for (int d = 0; d < density; ++d) {
                        for (int e = 0; e < this.dimensions; ++e) {
                            this.grid[i2][j][k][d][e] = this.r.nextFloat();
                        }
                    }
                }
            }
        }
    }

    private float distance(float[] a2, int[] offset, float[] b) {
        float[] m = new float[this.dimensions];
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            m[i2] = b[i2] - (a2[i2] + (float)offset[i2]);
        }
        float d = 0.0f;
        switch (this.metric) {
            case Linear: {
                for (int i3 = 0; i3 < this.dimensions; ++i3) {
                    d += m[i3] * m[i3];
                }
                return (float)Math.sqrt(d);
            }
            case Squared: {
                for (int i4 = 0; i4 < this.dimensions; ++i4) {
                    d += m[i4] * m[i4];
                }
                return d;
            }
            case Manhattan: {
                for (int i5 = 0; i5 < this.dimensions; ++i5) {
                    d += Math.abs(m[i5]);
                }
                return d;
            }
            case Chebyshev: {
                for (int i6 = 0; i6 < this.dimensions; ++i6) {
                    d = Math.max(Math.abs(m[i6]), d);
                }
                return d;
            }
            case Quadratic: {
                for (int i7 = 0; i7 < this.dimensions; ++i7) {
                    for (int j = i7; j < this.dimensions; ++j) {
                        d += m[i7] * m[j];
                    }
                }
                return d;
            }
            case Wiggly: {
                for (int i8 = 0; i8 < this.dimensions; ++i8) {
                    d = (float)((double)d + Math.pow(Math.abs(m[i8]), 15.0));
                }
                return (float)Math.pow(d, 0.06666667014360428);
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    public float get(float xin, float yin, float zin) {
        int i2;
        if (this.is2D) {
            throw new UnsupportedOperationException("Cannot create 3D Voronoi basis when instantiated with is2D = true.");
        }
        int[] cell = new int[]{this.fastfloor(xin), this.fastfloor(yin), this.fastfloor(zin)};
        float[] pos = new float[]{xin - (float)cell[0], yin - (float)cell[1], zin - (float)cell[2]};
        int i3 = 0;
        while (i3 < 3) {
            int n = i3++;
            cell[n] = cell[n] % this.size;
        }
        float[] distances = new float[this.level];
        for (i2 = 0; i2 < this.level; ++i2) {
            distances[i2] = Float.MAX_VALUE;
        }
        for (i2 = 0; i2 < order3D.length; ++i2) {
            boolean possible = true;
            float farDist = distances[this.level - 1];
            if (farDist < Float.MAX_VALUE) {
                for (int j = 0; j < 3; ++j) {
                    if (!(order3D[i2][j] < 0 && farDist < pos[j]) && (order3D[i2][j] <= 0 || !(farDist < 1.0f - pos[j]))) continue;
                    possible = false;
                    break;
                }
            }
            if (!possible) continue;
            int cx = (order3D[i2][0] + cell[0]) % this.size;
            int cy = (order3D[i2][1] + cell[1]) % this.size;
            int cz = (order3D[i2][2] + cell[2]) % this.size;
            block4: for (int j = 0; j < this.density; ++j) {
                float d = this.distance(this.grid[cx][cy][cz][j], order3D[i2], pos);
                for (int k = 0; k < this.level; ++k) {
                    if (!(d < distances[k])) continue;
                    for (int l2 = this.level - 1; l2 > k; --l2) {
                        distances[l2] = distances[l2 - 1];
                    }
                    distances[k] = d;
                    continue block4;
                }
            }
        }
        return distances[this.level - 1];
    }

    public float get(float xin, float yin) {
        int i2;
        if (!this.is2D) {
            throw new UnsupportedOperationException("Cannot create 2D Voronoi basis when instantiated with is2D = false.");
        }
        int[] cell = new int[]{this.fastfloor(xin), this.fastfloor(yin)};
        float[] pos = new float[]{xin - (float)cell[0], yin - (float)cell[1]};
        int i3 = 0;
        while (i3 < 2) {
            int n = i3++;
            cell[n] = cell[n] % this.size;
        }
        float[] distances = new float[this.level];
        for (i2 = 0; i2 < this.level; ++i2) {
            distances[i2] = Float.MAX_VALUE;
        }
        for (i2 = 0; i2 < order2D.length; ++i2) {
            boolean possible = true;
            float farDist = distances[this.level - 1];
            if (farDist < Float.MAX_VALUE) {
                for (int j = 0; j < this.dimensions; ++j) {
                    if (!(order2D[i2][j] < 0 && farDist < pos[j]) && (order2D[i2][j] <= 0 || !(farDist < 1.0f - pos[j]))) continue;
                    possible = false;
                    break;
                }
            }
            if (!possible) continue;
            int cx = (order2D[i2][0] + cell[0] + this.size) % this.size;
            int cy = (order2D[i2][1] + cell[1] + this.size) % this.size;
            block4: for (int j = 0; j < this.density; ++j) {
                float d = this.distance(this.grid[cx][cy][0][j], order2D[i2], pos);
                for (int k = 0; k < this.level; ++k) {
                    if (!(d < distances[k])) continue;
                    for (int l2 = this.level - 1; l2 > k; --l2) {
                        distances[l2] = distances[l2 - 1];
                    }
                    distances[k] = d;
                    continue block4;
                }
            }
        }
        return distances[this.level - 1];
    }

    private int fastfloor(float x) {
        return x > 0.0f ? (int)x : (int)x - 1;
    }

    public static enum DistanceMetric {
        Linear,
        Squared,
        Manhattan,
        Quadratic,
        Chebyshev,
        Wiggly;

    }
}

