/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.proxy;

import com.mohistmc.bukkit.nms.utils.RemapUtils;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class DelegateURLClassLoder
extends URLClassLoader {
    public static final String desc = DelegateURLClassLoder.class.getName().replace('.', '/');
    private final Map<String, Class<?>> classeCache = new HashMap();
    private static LaunchClassLoader launchClassLoader = (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public DelegateURLClassLoder(URL[] urls) {
        super(urls);
    }

    public DelegateURLClassLoder(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (RemapUtils.isNMSClass(name)) {
            String mapName = RemapUtils.map(name.replace('.', '/')).replace('/', '.');
            return launchClassLoader.findClass(mapName);
        }
        Class<?> result = this.classeCache.get(name);
        if (result != null) {
            return result;
        }
        String string = name.intern();
        synchronized (string) {
            result = this.remappedFindClass(name);
            if (result != null) {
                return result;
            }
            result = this.remappedFindClass(name);
            if (result == null) {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    result = launchClassLoader.getClass().getClassLoader().loadClass(name);
                }
            }
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
            this.cacheClass(name, result);
        }
        return result;
    }

    protected Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            InputStream stream;
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            if (url != null && (stream = url.openStream()) != null) {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                byte[] bytecode = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                result = this.defineClass(name, bytecode = RemapUtils.remapFindClass(bytecode), 0, bytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]));
                if (result != null) {
                    this.resolveClass(result);
                }
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to remap class " + name, t);
        }
        return result;
    }

    protected void cacheClass(String name, Class<?> clazz) {
        this.classeCache.put(name, clazz);
        if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            ConfigurationSerialization.registerClass(clazz);
        }
    }
}

