/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import com.mohistmc.MohistThreadCost;
import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.command.GiveCommand;
import com.mohistmc.command.ItemCommand;
import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.util.i18n.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MohistCommand
extends Command {
    private List<String> params = Arrays.asList("mods", "playermods", "printthreadcost", "lang", "item", "reload", "give");

    public MohistCommand(String name) {
        super(name);
        this.description = "Mohist related commands";
        this.usageMessage = "/mohist [mods|playermods|printthreadcost|lang|item|reload|give]";
        this.setPermission("mohist.command.mohist");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String string : this.params) {
                if (!string.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(string);
            }
        }
        if (args.length >= 3 && args[0].equals("give")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                list.add(player.getName());
            }
        }
        if (args.length == 2 && args[0].equals("item")) {
            list.add("info");
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp() || !this.testPermission(sender)) {
            sender.sendMessage(Message.getString("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "mods": {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + ServerAPI.getModSize() + " " + ServerAPI.getModList());
                break;
            }
            case "playermods": {
                if (args.length == 1) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                    return false;
                }
                Player player = Bukkit.getPlayer(args[1]);
                if (player != null) {
                    sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + PlayerAPI.getModSize(player) + " " + PlayerAPI.getModlist(player));
                    break;
                }
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The player [" + args[1] + "] is not online.");
                break;
            }
            case "printthreadcost": {
                MohistThreadCost.dumpThreadCpuTime();
                break;
            }
            case "lang": {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + Message.getLocale());
                break;
            }
            case "item": {
                if (args.length == 1) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: /mohist item info");
                    return false;
                }
                if ("info".equals(args[1].toLowerCase(Locale.ENGLISH))) {
                    ItemCommand.info(sender);
                    break;
                }
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: /mohist item info");
                break;
            }
            case "reload": {
                MohistConfig.instance.load();
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "mohist.yml reload complete.");
                break;
            }
            case "give": {
                GiveCommand.info(sender, args);
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }
}

