/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.common.threadpool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactory {
    private static ThreadFactory executorFactory = new ThreadFactory();
    private ExecutorService executors;

    private ThreadFactory() {
    }

    public static ThreadFactory getInstance() {
        return executorFactory;
    }

    public ExecutorService createScheduledThreadPool() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.executors = Executors.newScheduledThreadPool(availableProcessors * 10, this.getThreadFactory());
        return this.executors;
    }

    public ExecutorService createSingleThreadExecutor() {
        this.executors = Executors.newSingleThreadExecutor(this.getThreadFactory());
        return this.executors;
    }

    public ExecutorService createCachedThreadPool() {
        this.executors = Executors.newCachedThreadPool(this.getThreadFactory());
        return this.executors;
    }

    public ExecutorService createFixedThreadPool(int count) {
        this.executors = Executors.newFixedThreadPool(count, this.getThreadFactory());
        return this.executors;
    }

    private java.util.concurrent.ThreadFactory getThreadFactory() {
        return new java.util.concurrent.ThreadFactory(){
            AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                SecurityManager s = System.getSecurityManager();
                ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                Thread t = new Thread(group, r);
                t.setName("Task Thread - " + this.sn.incrementAndGet());
                return t;
            }
        };
    }
}

