/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.configuration;

import com.mohistmc.common.cache.EntityCache;
import com.mohistmc.configuration.BoolSetting;
import com.mohistmc.configuration.ConfigBase;
import com.mohistmc.configuration.Setting;
import com.mohistmc.util.Entity;
import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.file.YamlConfiguration;

public class EntityConfig
extends ConfigBase {
    private final String HEADER = "This is the main configuration file for Entities.\nUse carefully, it may break some mechanics";
    public static EntityConfig instance;
    public final BoolSetting skipEntityTicks = new BoolSetting(this, "settings.skip-entity-ticks", true, "If enabled, turns on entity tick skip feature.");
    public final BoolSetting skipActivationRange = new BoolSetting(this, "settings.skip-activation-range", false, "If enabled, skips entity activation range checks.");

    public EntityConfig() {
        super("entity.yml");
        this.init();
        instance = this;
    }

    public void init() {
        this.settings.put(this.skipEntityTicks.path, this.skipEntityTicks);
        this.settings.put(this.skipActivationRange.path, this.skipActivationRange);
        this.load();
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "This is the main configuration file for Entities.\nUse carefully, it may break some mechanics\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            for (EntityCache cache : Entity.entityCache.values()) {
                cache.tickInterval = this.config.getInt("world-settings." + cache.worldName + "." + cache.configPath + ".tick-interval", this.config.getInt("world-settings.default." + cache.configPath + ".tick-interval"));
            }
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.k.warn("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

