/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.common.cache.EntityCache;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class Entity {
    public static Map<Class<? extends vg>, EntityCache> entityCache = new HashMap<Class<? extends vg>, EntityCache>();

    public static String sanitizeClassName(Class clazz) {
        String name = clazz.getName().replace(".", "-");
        return name.replaceAll("[^A-Za-z0-9\\-]", "");
    }

    public static String sanitizeClassName(vg entity) {
        return Entity.sanitizeClassName(entity.getClass());
    }

    public static boolean canEntityTick(vg entity, amu world) {
        if (entity == null) {
            return false;
        }
        if (world.entityConfig == null) {
            return true;
        }
        if (MinecraftServer.entityConfig.skipEntityTicks.getValue().booleanValue()) {
            EntityCache eCache = entityCache.get(entity.getClass());
            if (eCache == null) {
                String eConfigPath = Entity.sanitizeClassName(entity);
                eCache = new EntityCache(entity.getClass(), world.V().j().toLowerCase(), eConfigPath, world.entityConfig.getInt(eConfigPath + ".tick-interval", 1));
                entityCache.put(entity.getClass(), eCache);
            }
            return eCache.tickInterval > 0 && world.V().e() % (long)eCache.tickInterval == 0L;
        }
        return true;
    }
}

