/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;

public enum Difficulty {
    PEACEFUL(0),
    EASY(1),
    NORMAL(2),
    HARD(3);

    private static final Map<Integer, Difficulty> BY_ID;
    private final int value;

    private Difficulty(int value) {
        this.value = value;
    }

    public static Difficulty getByValue(int value) {
        return BY_ID.get(value);
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_ID = Maps.newHashMap();
        for (Difficulty diff : Difficulty.values()) {
            BY_ID.put(diff.value, diff);
        }
    }
}

