/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;

public enum GameMode {
    CREATIVE(1),
    SURVIVAL(0),
    ADVENTURE(2),
    SPECTATOR(3);

    private static final Map<Integer, GameMode> BY_ID;
    private final int value;

    private GameMode(int value) {
        this.value = value;
    }

    public static GameMode getByValue(int value) {
        return BY_ID.get(value);
    }

    public int getValue() {
        return this.value;
    }

    static {
        BY_ID = Maps.newHashMap();
        for (GameMode mode : GameMode.values()) {
            BY_ID.put(mode.getValue(), mode);
        }
    }
}

