/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.mohistmc.util.i18n.Message;
import com.mohistmc.util.pluginmanager.PluginManagers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;

public class PluginsCommand
extends BukkitCommand {
    private final List<String> params = Arrays.asList("load", "unload", "reload");

    public PluginsCommand(String name) {
        super(name);
        this.description = Message.getString("pluginscommand.des");
        this.usageMessage = "/plugins [load|unload|reload] [name]";
        this.setAliases(Collections.singletonList("pl"));
        this.setPermission("bukkit.command.plugins");
    }

    private boolean checkparam(String args) {
        for (String param : this.params) {
            if (!args.equalsIgnoreCase(param)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            sender.sendMessage(Message.getString("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("Plugins " + this.getPluginList());
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "load": {
                PluginManagers.loadPluginCommand(sender, currentAlias, args);
                break;
            }
            case "unload": {
                PluginManagers.unloadPluginCommand(sender, currentAlias, args);
                break;
            }
            case "reload": {
                PluginManagers.reloadPluginCommand(sender, currentAlias, args);
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> tabs = new ArrayList<String>();
        if (args.length == 2 && (sender.isOp() || this.testPermission(sender)) && this.checkparam(args[0])) {
            for (Plugin pl2 : Bukkit.getServer().getPluginManager().getPlugins()) {
                String plname = pl2.getDescription().getName();
                if (!plname.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                tabs.add(plname);
            }
        }
        return tabs;
    }

    private String getPluginList() {
        TreeMap<String, ChatColor> plugins = new TreeMap<String, ChatColor>(String.CASE_INSENSITIVE_ORDER);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            plugins.put(plugin.getDescription().getName(), plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED);
        }
        StringBuilder pluginList = new StringBuilder();
        for (Map.Entry entry : plugins.entrySet()) {
            if (pluginList.length() > 0) {
                pluginList.append((Object)ChatColor.WHITE);
                pluginList.append(", ");
            }
            pluginList.append(entry.getValue());
            pluginList.append((String)entry.getKey());
        }
        return "(" + plugins.size() + "): " + pluginList.toString();
    }
}

