/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

public final class MapCursor {
    private byte x;
    private byte y;
    private byte direction;
    private byte type;
    private boolean visible;

    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setRawType(type);
        this.visible = visible;
    }

    public MapCursor(byte x, byte y, byte direction, Type type, boolean visible) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setType(type);
        this.visible = visible;
    }

    public byte getX() {
        return this.x;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public byte getY() {
        return this.y;
    }

    public void setY(byte y) {
        this.y = y;
    }

    public byte getDirection() {
        return this.direction;
    }

    public void setDirection(byte direction) {
        if (direction < 0 || direction > 15) {
            throw new IllegalArgumentException("Direction must be in the range 0-15");
        }
        this.direction = direction;
    }

    public Type getType() {
        return Type.byValue(this.type);
    }

    public void setType(Type type) {
        this.setRawType(type.value);
    }

    public byte getRawType() {
        return this.type;
    }

    public void setRawType(byte type) {
        if (type < 0 || type > 15) {
            throw new IllegalArgumentException("Type must be in the range 0-15");
        }
        this.type = type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static enum Type {
        WHITE_POINTER(0),
        GREEN_POINTER(1),
        RED_POINTER(2),
        BLUE_POINTER(3),
        WHITE_CROSS(4),
        RED_MARKER(5),
        WHITE_CIRCLE(6),
        SMALL_WHITE_CIRCLE(7),
        MANSION(8),
        TEMPLE(9);

        private byte value;

        private Type(int value) {
            this.value = (byte)value;
        }

        public static Type byValue(byte value) {
            for (Type t : Type.values()) {
                if (t.value != value) continue;
                return t;
            }
            return null;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

