/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.mohistmc.MohistMC;
import com.mohistmc.util.i18n.Message;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.SpigotConfig;

public class SpigotWorldConfig {
    private final String worldName;
    private final YamlConfiguration config;
    public int cactusModifier;
    public int caneModifier;
    public int melonModifier;
    public int mushroomModifier;
    public int pumpkinModifier;
    public int saplingModifier;
    public int wheatModifier;
    public int wartModifier;
    public int vineModifier;
    public int cocoaModifier;
    public double itemMerge;
    public double expMerge;
    public int viewDistance;
    public byte mobSpawnRange;
    public int itemDespawnRate;
    public int animalActivationRange = 32;
    public int monsterActivationRange = 32;
    public int miscActivationRange = 16;
    public int waterActivationRange = 16;
    public boolean tickInactiveVillagers = true;
    public int playerTrackingRange = 48;
    public int animalTrackingRange = 48;
    public int monsterTrackingRange = 48;
    public int miscTrackingRange = 32;
    public int otherTrackingRange = 64;
    public int hopperTransfer;
    public int hopperCheck;
    public int hopperAmount;
    public boolean randomLightUpdates;
    public boolean saveStructureInfo;
    public int arrowDespawnRate;
    public boolean zombieAggressiveTowardsVillager;
    public boolean nerfSpawnerMobs;
    public boolean enableZombiePigmenPortalSpawns;
    public int dragonDeathSoundRadius;
    public int witherSpawnSoundRadius;
    public int villageSeed;
    public int largeFeatureSeed;
    public int monumentSeed;
    public int slimeSeed;
    public float jumpWalkExhaustion;
    public float jumpSprintExhaustion;
    public float combatExhaustion;
    public float regenExhaustion;
    public float swimMultiplier;
    public float sprintMultiplier;
    public float otherMultiplier;
    public int currentPrimedTnt = 0;
    public int maxTntTicksPerTick;
    public int hangingTickFrequency;
    public int tileMaxTickTime = 1000;
    public int entityMaxTickTime = 1000;
    public double squidSpawnRangeMin;
    private boolean verbose;
    public int cactusMaxHeight;
    public int reedMaxHeight;

    public SpigotWorldConfig(String worldName) {
        this.worldName = worldName;
        this.config = SpigotConfig.config;
        this.init();
    }

    public void init() {
        this.verbose = this.getBoolean("verbose", true);
        Object[] p2 = new Object[]{this.worldName};
        MohistMC.LOGGER.info(Message.getFormatString("world.settings", p2));
        SpigotConfig.readConfig(SpigotWorldConfig.class, this);
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
    }

    public boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    public double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    public int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    public <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    public String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private int getAndValidateGrowth(String crop) {
        int modifier = this.getInt("growth." + crop.toLowerCase(Locale.ENGLISH) + "-modifier", 100);
        if (modifier == 0) {
            this.log(Message.getFormatString("growth.modifier.defaulting", new Object[]{crop}));
            modifier = 100;
        }
        this.log(Message.getFormatString("growth.modifier", new Object[]{crop, modifier}));
        return modifier;
    }

    private void growthModifiers() {
        this.cactusModifier = this.getAndValidateGrowth("Cactus");
        this.caneModifier = this.getAndValidateGrowth("Cane");
        this.melonModifier = this.getAndValidateGrowth("Melon");
        this.mushroomModifier = this.getAndValidateGrowth("Mushroom");
        this.pumpkinModifier = this.getAndValidateGrowth("Pumpkin");
        this.saplingModifier = this.getAndValidateGrowth("Sapling");
        this.wheatModifier = this.getAndValidateGrowth("Wheat");
        this.wartModifier = this.getAndValidateGrowth("NetherWart");
        this.vineModifier = this.getAndValidateGrowth("Vine");
        this.cocoaModifier = this.getAndValidateGrowth("Cocoa");
    }

    private void itemMerge() {
        this.itemMerge = this.getDouble("merge-radius.item", 2.5);
        this.log(Message.getFormatString("merge.radius.item", new Object[]{this.itemMerge}));
    }

    private void expMerge() {
        this.expMerge = this.getDouble("merge-radius.exp", 3.0);
        this.log(Message.getFormatString("merge.radius.exp", new Object[]{this.expMerge}));
    }

    private void viewDistance() {
        this.viewDistance = this.getInt("view-distance", Bukkit.getViewDistance());
        this.log(Message.getFormatString("view.distance", new Object[]{this.viewDistance}));
    }

    private void mobSpawnRange() {
        this.mobSpawnRange = (byte)this.getInt("mob-spawn-range", 4);
        this.log(Message.getFormatString("mob.spawn.range", new Object[]{this.mobSpawnRange}));
    }

    private void itemDespawnRate() {
        this.itemDespawnRate = this.getInt("item-despawn-rate", 6000);
        this.log(Message.getFormatString("item.despawn.rate", new Object[]{this.itemDespawnRate}));
    }

    private void activationRange() {
        this.animalActivationRange = this.getInt("entity-activation-range.animals", this.animalActivationRange);
        this.monsterActivationRange = this.getInt("entity-activation-range.monsters", this.monsterActivationRange);
        this.miscActivationRange = this.getInt("entity-activation-range.misc", this.miscActivationRange);
        this.waterActivationRange = this.getInt("entity-activation-range.water", this.waterActivationRange);
        this.tickInactiveVillagers = this.getBoolean("entity-activation-range.tick-inactive-villagers", this.tickInactiveVillagers);
        this.log(Message.getFormatString("entity.activation.range", new Object[]{this.animalActivationRange, this.monsterActivationRange, this.miscActivationRange, this.tickInactiveVillagers}));
    }

    private void trackingRange() {
        this.playerTrackingRange = this.getInt("entity-tracking-range.players", this.playerTrackingRange);
        this.animalTrackingRange = this.getInt("entity-tracking-range.animals", this.animalTrackingRange);
        this.monsterTrackingRange = this.getInt("entity-tracking-range.monsters", this.monsterTrackingRange);
        this.miscTrackingRange = this.getInt("entity-tracking-range.misc", this.miscTrackingRange);
        this.otherTrackingRange = this.getInt("entity-tracking-range.other", this.otherTrackingRange);
        this.log(Message.getFormatString("entity.tracking.range", new Object[]{this.playerTrackingRange, this.animalTrackingRange, this.monsterTrackingRange, this.miscTrackingRange, this.otherTrackingRange}));
    }

    private void hoppers() {
        this.hopperTransfer = this.getInt("ticks-per.hopper-transfer", 8);
        if (SpigotConfig.version < 11) {
            this.set("ticks-per.hopper-check", 1);
        }
        this.hopperCheck = this.getInt("ticks-per.hopper-check", 1);
        this.hopperAmount = this.getInt("hopper-amount", 1);
        this.log(Message.getFormatString("ticks.per.hopper.transfer", new Object[]{this.hopperTransfer, this.hopperCheck, this.hopperAmount}));
    }

    private void lightUpdates() {
        this.randomLightUpdates = this.getBoolean("random-light-updates", false);
        this.log(Message.getFormatString("random.light.updates", new Object[]{this.randomLightUpdates}));
    }

    private void structureInfo() {
        this.saveStructureInfo = this.getBoolean("save-structure-info", true);
        this.log(Message.getFormatString("save.structure.info", new Object[]{this.saveStructureInfo}));
        if (!this.saveStructureInfo) {
            this.log(Message.getString("save.structure.info.error"));
            this.log(Message.getString("save.structure.info.error"));
        }
    }

    private void arrowDespawnRate() {
        this.arrowDespawnRate = this.getInt("arrow-despawn-rate", 1200);
        this.log(Message.getFormatString("arrow.despawn.rate", new Object[]{String.valueOf(this.arrowDespawnRate)}));
    }

    private void zombieAggressiveTowardsVillager() {
        this.zombieAggressiveTowardsVillager = this.getBoolean("zombie-aggressive-towards-villager", true);
        this.log(Message.getFormatString("zombie.aggressive.towards.villager", new Object[]{this.zombieAggressiveTowardsVillager}));
    }

    private void nerfSpawnerMobs() {
        this.nerfSpawnerMobs = this.getBoolean("nerf-spawner-mobs", false);
        this.log(Message.getFormatString("nerf.spawner.mobs", new Object[]{this.nerfSpawnerMobs}));
    }

    private void enableZombiePigmenPortalSpawns() {
        this.enableZombiePigmenPortalSpawns = this.getBoolean("enable-zombie-pigmen-portal-spawns", true);
        this.log(Message.getFormatString("enable.zombie.pigmen.portal.spawns", new Object[]{this.enableZombiePigmenPortalSpawns}));
    }

    private void keepDragonDeathPerWorld() {
        this.dragonDeathSoundRadius = this.getInt("dragon-death-sound-radius", 0);
    }

    private void witherSpawnSoundRadius() {
        this.witherSpawnSoundRadius = this.getInt("wither-spawn-sound-radius", 0);
    }

    private void initWorldGenSeeds() {
        this.villageSeed = this.getInt("seed-village", 10387312);
        this.largeFeatureSeed = this.getInt("seed-feature", 14357617);
        this.monumentSeed = this.getInt("seed-monument", 10387313);
        this.slimeSeed = this.getInt("seed-slime", 987234911);
        this.log(Message.getFormatString("custom.map.seeds", new Object[]{String.valueOf(this.villageSeed), String.valueOf(this.largeFeatureSeed), String.valueOf(this.monumentSeed), String.valueOf(this.slimeSeed)}));
    }

    private void initHunger() {
        if (SpigotConfig.version < 10) {
            this.set("hunger.walk-exhaustion", null);
            this.set("hunger.sprint-exhaustion", null);
            this.set("hunger.combat-exhaustion", 0.1);
            this.set("hunger.regen-exhaustion", 6.0);
        }
        this.jumpWalkExhaustion = (float)this.getDouble("hunger.jump-walk-exhaustion", 0.05);
        this.jumpSprintExhaustion = (float)this.getDouble("hunger.jump-sprint-exhaustion", 0.2);
        this.combatExhaustion = (float)this.getDouble("hunger.combat-exhaustion", 0.1);
        this.regenExhaustion = (float)this.getDouble("hunger.regen-exhaustion", 6.0);
        this.swimMultiplier = (float)this.getDouble("hunger.swim-multiplier", 0.01);
        this.sprintMultiplier = (float)this.getDouble("hunger.sprint-multiplier", 0.1);
        this.otherMultiplier = (float)this.getDouble("hunger.other-multiplier", 0.0);
    }

    private void maxTntPerTick() {
        if (SpigotConfig.version < 7) {
            this.set("max-tnt-per-tick", 100);
        }
        this.maxTntTicksPerTick = this.getInt("max-tnt-per-tick", 100);
        this.log(Message.getFormatString("max-tnt.per.tick", new Object[]{this.maxTntTicksPerTick}));
    }

    private void hangingTickFrequency() {
        this.hangingTickFrequency = this.getInt("hanging-tick-frequency", 100);
    }

    private void maxTickTimes() {
        this.tileMaxTickTime = this.getInt("max-tick-time.tile", 1000);
        this.entityMaxTickTime = this.getInt("max-tick-time.entity", 1000);
        this.log(Message.getFormatString("max.tick.time.tile", new Object[]{this.tileMaxTickTime, this.entityMaxTickTime}));
    }

    private void squidSpawnRange() {
        this.squidSpawnRangeMin = this.getDouble("squid-spawn-range.min", 45.0);
    }

    private void blockGrowthHeight() {
        this.cactusMaxHeight = this.getInt("max-growth-height.cactus", 3);
        this.reedMaxHeight = this.getInt("max-growth-height.reeds", 3);
        this.log("Max height for cactus growth " + this.cactusMaxHeight + ". Max height for reed growth " + this.reedMaxHeight);
    }
}

