/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CacheEntry;
import org.cache2k.CustomizationException;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryPolicyException;
import org.cache2k.core.HeapCache;
import org.cache2k.core.InternalCache;
import org.cache2k.core.ResiliencePolicyException;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.experimentalApi.AsyncCacheWriter;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.LoadedEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.Semantic;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.AsyncCacheLoader;
import org.cache2k.integration.CacheLoaderException;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.CacheWriterException;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.RefreshedTimeWrapper;

public abstract class EntryAction<K, V, R>
implements AsyncCacheLoader.Context<K, V>,
AsyncCacheLoader.Callback<K, V>,
AsyncCacheWriter.Callback,
Progress<K, V, R> {
    static final Entry NON_FRESH_DUMMY = new Entry();
    InternalCache<K, V> userCache;
    HeapCache<K, V> heapCache;
    K key;
    Semantic<K, V, R> operation;
    Entry<K, V> entry;
    V newValueOrException;
    V oldValueOrException;
    R result;
    long currentTime;
    long lastRefreshTime;
    long loadStartedTime;
    RuntimeException exceptionToPropagate;
    boolean remove;
    boolean expiredImmediately;
    long expiry = 0L;
    boolean entryLocked = false;
    boolean heapDataValid = false;
    boolean storageDataValid = false;
    boolean needsFinish = true;
    boolean storageRead = false;
    boolean storageMiss = false;
    boolean heapMiss = false;
    boolean wantData = false;
    boolean countMiss = false;
    boolean heapHit = false;
    boolean doNotCountAccess = false;
    boolean loadAndMutate = false;
    boolean load = false;
    boolean refresh = false;
    boolean successfulLoad = false;
    boolean suppressException = false;
    Thread syncThread;
    ActionCompletedCallback completedCallback;

    public EntryAction(HeapCache<K, V> _heapCache, InternalCache<K, V> _userCache, Semantic<K, V, R> op, K k, Entry<K, V> e, ActionCompletedCallback cb) {
        this.heapCache = _heapCache;
        this.userCache = _userCache;
        this.operation = op;
        this.key = k;
        this.entry = e != null ? e : NON_FRESH_DUMMY;
        if (cb == null) {
            this.syncThread = Thread.currentThread();
        } else {
            this.completedCallback = cb;
        }
    }

    public EntryAction(HeapCache<K, V> _heapCache, InternalCache<K, V> _userCache, Semantic<K, V, R> op, K k, Entry<K, V> e) {
        this(_heapCache, _userCache, op, k, e, null);
    }

    protected AdvancedCacheLoader<K, V> loader() {
        return this.heapCache.loader;
    }

    protected AsyncCacheLoader<K, V> asyncLoader() {
        return null;
    }

    protected CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    protected CacheWriter<K, V> writer() {
        return null;
    }

    protected boolean mightHaveListeners() {
        return false;
    }

    protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
        return null;
    }

    protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
        return null;
    }

    protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
        return null;
    }

    protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
        return null;
    }

    protected abstract TimingHandler<K, V> timing();

    public K getKey() {
        return (K)this.entry.getKey();
    }

    @Override
    public long getCurrentTime() {
        if (this.currentTime > 0L) {
            return this.currentTime;
        }
        this.currentTime = this.millis();
        return this.currentTime;
    }

    public V getCachedValue() {
        Object v = this.entry.getValueOrException();
        if (v instanceof ExceptionWrapper || this.entry.isVirgin()) {
            return null;
        }
        return (V)v;
    }

    public Throwable getCachedException() {
        Object v = this.entry.getValueOrException();
        if (v instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)v).getException();
        }
        return null;
    }

    @Override
    public boolean isPresent() {
        this.doNotCountAccess = true;
        return this.successfulLoad || this.entry.hasFreshData(this.heapCache.getClock());
    }

    @Override
    public boolean isPresentOrInRefreshProbation() {
        this.doNotCountAccess = true;
        return this.successfulLoad || this.entry.getNextRefreshTime() == 6L || this.entry.hasFreshData(this.heapCache.getClock());
    }

    @Override
    public boolean isPresentOrMiss() {
        if (this.successfulLoad || this.entry.hasFreshData(this.heapCache.getClock())) {
            return true;
        }
        this.countMiss = true;
        return false;
    }

    @Override
    public void wantData() {
        this.wantData = true;
        this.retrieveDataFromHeap();
    }

    public void retrieveDataFromHeap() {
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY && (e = this.heapCache.lookupEntry(this.key)) == null) {
            this.heapMiss();
            return;
        }
        this.heapHit(e);
    }

    private long millis() {
        return this.heapCache.getClock().millis();
    }

    public void heapMiss() {
        this.heapMiss = true;
        this.examine();
    }

    public void heapHit(Entry<K, V> e) {
        this.heapHit = true;
        this.entry = e;
        this.examine();
    }

    public void examine() {
        this.operation.examine(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    @Override
    public void wantMutation() {
        if (!this.entryLocked && this.wantData) {
            this.lockFor(3);
            this.countMiss = false;
            this.operation.examine(this, this.entry);
            if (this.needsFinish) {
                this.finish();
            }
            return;
        }
        this.operation.update(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    public void finish() {
        this.needsFinish = false;
        this.noMutationRequested();
    }

    @Override
    public void loadAndMutation() {
        this.loadAndMutate = true;
        this.load();
    }

    @Override
    public void refresh() {
        this.refresh = true;
        this.load();
    }

    @Override
    public void load() {
        Object v;
        long nrt;
        long t0;
        this.lockFor(4);
        this.needsFinish = false;
        this.load = true;
        Entry<K, V> e = this.entry;
        long l = t0 = this.heapCache.isUpdateTimeNeeded() ? (this.lastRefreshTime = (this.loadStartedTime = this.getCurrentTime())) : 0L;
        if (e.getNextRefreshTime() == 6L && (nrt = e.getRefreshProbationNextRefreshTime()) > t0) {
            this.reviveRefreshedEntry(nrt);
            return;
        }
        AsyncCacheLoader<K, V> _asyncLoader = this.asyncLoader();
        if (_asyncLoader != null) {
            this.lockFor(17);
            try {
                _asyncLoader.load(this.key, (AsyncCacheLoader.Context)this, (AsyncCacheLoader.Callback)this);
            }
            catch (Exception ex) {
                this.onLoadFailure(ex);
                this.exceptionToPropagate = new CacheLoaderException((Throwable)ex);
                return;
            }
            this.asyncOperationStarted();
            return;
        }
        AdvancedCacheLoader<K, V> _loader = this.loader();
        if (_loader == null) {
            this.mutationAbort(null);
            return;
        }
        try {
            v = e.isVirgin() ? _loader.load(this.key, t0, null) : _loader.load(this.key, t0, e);
        }
        catch (Throwable _ouch) {
            this.onLoadFailureIntern(_ouch);
            return;
        }
        this.onLoadSuccessIntern(v);
    }

    public void reviveRefreshedEntry(long nrt) {
        this.metrics().refreshedHit();
        Entry<K, V> e = this.entry;
        this.newValueOrException = e.getValueOrException();
        this.lastRefreshTime = e.getRefreshTime();
        this.expiry = nrt;
        this.expiryCalculated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFor(int ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
        while (true) {
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockForNoHit(int ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
        while (true) {
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
    }

    public void onLoadSuccess(V v) {
        this.checkEntryStateOnLoadCallback();
        this.onLoadSuccessIntern(v);
    }

    public void onLoadFailure(Throwable t) {
        this.checkEntryStateOnLoadCallback();
        this.onLoadFailureIntern(t);
    }

    private void checkEntryStateOnLoadCallback() {
        if (!this.entry.checkAndSwitchProcessingState(17, 5)) {
            throw new IllegalStateException("async callback on wrong entry state. duplicate callback?");
        }
    }

    private void onLoadSuccessIntern(V v) {
        if (v instanceof RefreshedTimeWrapper) {
            RefreshedTimeWrapper wr = (RefreshedTimeWrapper)v;
            this.lastRefreshTime = wr.getRefreshTime();
            v = wr.getValue();
        }
        this.newValueOrException = v;
        this.loadCompleted();
    }

    private void onLoadFailureIntern(Throwable t) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, t, this.loadStartedTime, this.entry);
        this.loadCompleted();
    }

    public void loadCompleted() {
        this.entry.nextProcessingStep(5);
        this.entryLocked = true;
        if (!this.metrics().isDisabled() && this.heapCache.isUpdateTimeNeeded()) {
            long _loadCompletedTime = this.millis();
            long _delta = _loadCompletedTime - this.loadStartedTime;
            if (this.refresh) {
                this.metrics().refresh(_delta);
            } else if (this.entry.isVirgin() || !this.storageRead) {
                this.metrics().load(_delta);
            } else {
                this.metrics().reload(_delta);
            }
        }
        this.mutationCalculateExpiry();
    }

    @Override
    public void result(R r) {
        this.result = r;
    }

    @Override
    public void entryResult(ExaminationEntry e) {
        this.result = this.heapCache.returnEntry(e);
    }

    @Override
    public RuntimeException propagateException(K key, ExceptionInformation inf) {
        return this.heapCache.exceptionPropagator.propagateException(key, inf);
    }

    @Override
    public void put(V value) {
        this.lockFor(3);
        this.needsFinish = false;
        this.newValueOrException = value;
        this.lastRefreshTime = !this.heapCache.isUpdateTimeNeeded() ? 0L : this.getCurrentTime();
        this.mutationCalculateExpiry();
    }

    @Override
    public void remove() {
        this.lockForNoHit(3);
        this.needsFinish = false;
        this.remove = true;
        this.mutationMayCallWriter();
    }

    @Override
    public void expire(long expiryTime) {
        this.lockForNoHit(3);
        this.needsFinish = false;
        this.newValueOrException = this.entry.getValueOrException();
        if (this.heapCache.isUpdateTimeNeeded()) {
            this.lastRefreshTime = this.entry.getRefreshTime();
        }
        this.expiry = expiryTime;
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.setUntil((ExceptionWrapper)ExceptionWrapper.class.cast(this.newValueOrException));
        }
        this.checkKeepOrRemove();
    }

    @Override
    public void putAndSetExpiry(V value, long expiryTime, long refreshTime) {
        this.lockFor(3);
        this.needsFinish = false;
        this.newValueOrException = value;
        if (refreshTime >= 0L) {
            this.lastRefreshTime = refreshTime;
        } else if (this.heapCache.isUpdateTimeNeeded()) {
            this.lastRefreshTime = this.getCurrentTime();
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.setUntil((ExceptionWrapper)ExceptionWrapper.class.cast(this.newValueOrException));
        }
        if (expiryTime != -1L) {
            this.expiry = expiryTime;
            this.expiryCalculated();
        } else {
            this.mutationCalculateExpiry();
        }
    }

    public void mutationCalculateExpiry() {
        this.entry.nextProcessingStep(8);
        if (this.newValueOrException instanceof ExceptionWrapper) {
            try {
                this.expiry = 0L;
                ExceptionWrapper ew = (ExceptionWrapper)this.newValueOrException;
                if ((this.entry.isDataValid() || this.entry.isExpired()) && this.entry.getException() == null) {
                    this.expiry = this.timing().suppressExceptionUntil(this.entry, ew);
                }
                if (this.expiry > this.loadStartedTime) {
                    this.suppressException = true;
                    this.newValueOrException = this.entry.getValueOrException();
                    this.lastRefreshTime = this.entry.getRefreshTime();
                    this.metrics().suppressedException();
                    this.entry.setSuppressedLoadExceptionInformation(ew);
                } else {
                    if (this.load) {
                        this.metrics().loadException();
                    }
                    this.expiry = this.timing().cacheExceptionUntil(this.entry, ew);
                }
                this.setUntil(ew);
            }
            catch (Throwable ex) {
                if (this.load) {
                    this.resiliencePolicyException((RuntimeException)((Object)new ResiliencePolicyException(ex)));
                    return;
                }
                this.expiryCalculationException(ex);
                return;
            }
        }
        try {
            this.expiry = this.timing().calculateNextRefreshTime(this.entry, this.newValueOrException, this.lastRefreshTime);
            if (this.newValueOrException == null && this.heapCache.isRejectNullValues() && this.expiry != 0L) {
                RuntimeException _ouch = this.heapCache.returnNullValueDetectedException();
                if (this.load) {
                    this.decideForLoaderExceptionAfterExpiryCalculation((RuntimeException)((Object)new ResiliencePolicyException(_ouch)));
                    return;
                }
                this.mutationAbort(_ouch);
                return;
            }
            this.entry.resetSuppressedLoadExceptionInformation();
        }
        catch (Throwable ex) {
            if (this.load) {
                this.decideForLoaderExceptionAfterExpiryCalculation((RuntimeException)((Object)new ExpiryPolicyException(ex)));
                return;
            }
            this.expiryCalculationException(ex);
            return;
        }
        this.expiryCalculated();
    }

    private void decideForLoaderExceptionAfterExpiryCalculation(RuntimeException _ouch) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, (Throwable)_ouch, this.loadStartedTime, this.entry);
        this.expiry = 0L;
        this.mutationCalculateExpiry();
    }

    private void resiliencePolicyException(RuntimeException _ouch) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, (Throwable)_ouch, this.loadStartedTime, this.entry);
        this.expiry = 0L;
        this.expiryCalculated();
    }

    private void setUntil(ExceptionWrapper _ew) {
        if (this.expiry < 0L) {
            _ew.setUntil(-this.expiry);
        } else if (this.expiry >= 32L) {
            _ew.setUntil(this.expiry);
        }
    }

    public void expiryCalculationException(Throwable t) {
        this.mutationAbort((RuntimeException)((Object)new ExpiryPolicyException(t)));
    }

    public void expiryCalculated() {
        this.entry.nextProcessingStep(9);
        if (this.load) {
            if (this.loadAndMutate) {
                this.loadAndExpiryCalculatedMutateAgain();
                return;
            }
            this.checkKeepOrRemove();
            return;
        }
        if (this.expiry > 0L || this.expiry == -1L || this.expiry < 0L && -this.expiry > this.loadStartedTime) {
            if (this.entry.isVirgin()) {
                this.metrics().putNewEntry();
            } else if (!this.wantData) {
                this.metrics().putNoReadHit();
            } else {
                this.metrics().putHit();
            }
        }
        this.mutationMayCallWriter();
    }

    public void loadAndExpiryCalculatedMutateAgain() {
        this.loadAndMutate = false;
        this.load = false;
        this.successfulLoad = true;
        this.needsFinish = true;
        LoadedEntry ee = new LoadedEntry<K, V>(){

            @Override
            public K getKey() {
                return EntryAction.this.entry.getKey();
            }

            @Override
            public V getValueOrException() {
                return EntryAction.this.newValueOrException;
            }

            @Override
            public long getRefreshTime() {
                return EntryAction.this.lastRefreshTime;
            }
        };
        this.operation.update(this, ee);
        if (this.needsFinish) {
            this.updateDidNotTriggerDifferentMutationStoreLoadedValue();
        }
    }

    public void updateDidNotTriggerDifferentMutationStoreLoadedValue() {
        this.checkKeepOrRemove();
    }

    public void mutationMayCallWriter() {
        CacheWriter<K, V> _writer = this.writer();
        if (_writer == null) {
            this.skipWritingNoWriter();
            return;
        }
        if (this.remove) {
            try {
                this.entry.nextProcessingStep(10);
                _writer.delete(this.key);
            }
            catch (Throwable t) {
                this.onWriteFailure(t);
                return;
            }
            this.onWriteSuccess();
            return;
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.skipWritingForException();
            return;
        }
        this.entry.nextProcessingStep(10);
        try {
            _writer.write(this.key, this.newValueOrException);
        }
        catch (Throwable t) {
            this.onWriteFailure(t);
            return;
        }
        this.onWriteSuccess();
    }

    @Override
    public void onWriteSuccess() {
        this.entry.nextProcessingStep(11);
        this.checkKeepOrRemove();
    }

    @Override
    public void onWriteFailure(Throwable t) {
        this.mutationAbort((RuntimeException)new CacheWriterException(t));
    }

    public void skipWritingForException() {
        this.checkKeepOrRemove();
    }

    public void skipWritingNoWriter() {
        this.checkKeepOrRemove();
    }

    public void checkKeepOrRemove() {
        boolean _hasKeepAfterExpired = this.heapCache.isKeepAfterExpired();
        if (this.expiry != 0L || this.remove || _hasKeepAfterExpired) {
            this.mutationUpdateHeap();
            return;
        }
        if (_hasKeepAfterExpired) {
            this.expiredImmediatelyKeepData();
            return;
        }
        this.expiredImmediatelyAndRemove();
    }

    public void expiredImmediatelyKeepData() {
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    public void expiredImmediatelyAndRemove() {
        this.remove = true;
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationUpdateHeap() {
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            if (this.heapCache.isRecordRefreshTime()) {
                this.entry.setRefreshTime(this.lastRefreshTime);
            }
            if (this.remove) {
                if (this.expiredImmediately) {
                    this.entry.setNextRefreshTime(4L);
                    this.entry.setValueOrException((Object)this.newValueOrException);
                } else if (!this.entry.isVirgin()) {
                    this.entry.setNextRefreshTime(2L);
                }
            } else {
                this.oldValueOrException = this.entry.getValueOrException();
                this.entry.setValueOrException((Object)this.newValueOrException);
            }
        }
        this.heapCache.eviction.updateWeight(this.entry);
        this.mutationMayStore();
    }

    public void mutationMayStore() {
        this.skipStore();
    }

    public void skipStore() {
        this.callListeners();
    }

    public void callListeners() {
        if (!this.mightHaveListeners()) {
            this.mutationReleaseLockAndStartTimer();
            return;
        }
        CacheEntry<K, V> _currentEntry = this.heapCache.returnCacheEntry(this.entry);
        if (this.expiredImmediately) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryExpiredListeners() != null) {
                for (CacheEntryExpiredListener<K, V> l : this.entryExpiredListeners()) {
                    try {
                        l.onEntryExpired(this.userCache, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.remove) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryRemovedListeners() != null) {
                for (CacheEntryRemovedListener<K, V> l : this.entryRemovedListeners()) {
                    try {
                        l.onEntryRemoved(this.userCache, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.storageDataValid || this.heapDataValid) {
            if (this.entryUpdatedListeners() != null) {
                CacheEntry<Object, V> _previousEntry = this.heapCache.returnCacheEntry(this.entry.getKey(), this.oldValueOrException);
                for (CacheEntryUpdatedListener<K, V> l : this.entryUpdatedListeners()) {
                    try {
                        l.onEntryUpdated(this.userCache, _previousEntry, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.entryCreatedListeners() != null) {
            for (CacheEntryCreatedListener<K, V> l : this.entryCreatedListeners()) {
                try {
                    l.onEntryCreated(this.userCache, _currentEntry);
                }
                catch (Throwable t) {
                    this.exceptionToPropagate = new ListenerException(t);
                }
            }
        }
        this.mutationReleaseLockAndStartTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationReleaseLockAndStartTimer() {
        if (!(!this.load || this.remove && this.entry.getValueOrException() == null && this.heapCache.isRejectNullValues())) {
            this.operation.loaded(this, this.entry);
        }
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.processingDone();
            this.entryLocked = false;
            if (this.refresh) {
                this.heapCache.startRefreshProbationTimer(this.entry, this.expiry);
                this.updateMutationStatistics();
                this.mutationDone();
                return;
            }
            if (this.remove) {
                this.heapCache.removeEntry(this.entry);
            } else {
                this.entry.setNextRefreshTime(this.timing().stopStartTimer(this.expiry, this.entry));
                if (this.entry.isExpired()) {
                    this.entry.setNextRefreshTime(32L);
                    this.userCache.expireOrScheduleFinalExpireEvent(this.entry);
                }
            }
        }
        this.updateMutationStatistics();
        this.mutationDone();
    }

    public void updateMutationStatistics() {
        if (this.loadStartedTime > 0L) {
            return;
        }
        this.updateOnlyReadStatistics();
    }

    public void updateOnlyReadStatistics() {
        if (this.countMiss) {
            if (this.heapHit) {
                this.metrics().peekHitNotFresh();
            }
            if (this.heapMiss) {
                this.metrics().peekMiss();
            }
        } else if (this.doNotCountAccess && this.heapHit) {
            this.metrics().heapHitButNoRead();
        }
    }

    @Override
    public void failure(RuntimeException t) {
        this.updateOnlyReadStatistics();
        this.mutationAbort(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void examinationAbort(CustomizationException t) {
        this.exceptionToPropagate = t;
        if (this.entryLocked) {
            Entry<K, V> entry = this.entry;
            synchronized (entry) {
                this.entry.processingDone();
                this.entryLocked = false;
            }
        }
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationAbort(RuntimeException t) {
        this.exceptionToPropagate = t;
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.processingDone();
            this.entryLocked = false;
            this.needsFinish = false;
        }
        this.ready();
    }

    public void mutationDone() {
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMutationRequested() {
        if (this.entryLocked) {
            Entry<K, V> entry = this.entry;
            synchronized (entry) {
                this.entry.processingDone();
                if (this.entry.isVirgin()) {
                    this.heapCache.removeEntry(this.entry);
                }
            }
            this.entryLocked = false;
        }
        this.updateOnlyReadStatistics();
        this.ready();
    }

    public void ready() {
        if (this.completedCallback != null) {
            this.completedCallback.entryActionCompleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationStarted() {
        if (this.syncThread == Thread.currentThread()) {
            Entry<K, V> entry = this.entry;
            synchronized (entry) {
                while (this.entry.isProcessing()) {
                    try {
                        this.entry.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.entryLocked = false;
        }
    }

    public static interface ActionCompletedCallback {
        public void entryActionCompleted(EntryAction var1);
    }

    public static class ListenerException
    extends CustomizationException {
        public ListenerException(Throwable cause) {
            super(cause);
        }
    }

    public static class ProcessingFailureException
    extends CustomizationException {
        public ProcessingFailureException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageWriteException
    extends CustomizationException {
        public StorageWriteException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageReadException
    extends CustomizationException {
        public StorageReadException(Throwable cause) {
            super(cause);
        }
    }
}

